package me.ahoo.pigeon.core.security.command.privilege;

import lombok.var;
import me.ahoo.pigeon.core.security.SecurityContext;

import java.util.Map;
import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time 2020/10/16 23:45
 **/
public class PrivilegeGroup implements PrivilegeChecker {
    /**
     * 1. 命令白名单 主要 给 未登录用户使用
     */
    private CommandPrivilegeChecker unAuthorization;

    /**
     * 2. 所有已登录的用户
     */
    private CommandPrivilegeChecker authorization;
    /**
     * 3. 用户授权
     */
    private Map<Long, CommandPrivilegeChecker> users;
    /**
     * 4. 角色授权
     */
    private Map<String, CommandPrivilegeChecker> roles;

    public CommandPrivilegeChecker getUnAuthorization() {
        return unAuthorization;
    }

    public void setUnAuthorization(CommandPrivilegeChecker all) {
        this.unAuthorization = all;
    }

    public CommandPrivilegeChecker getAuthorization() {
        return authorization;
    }

    public void setAuthorization(CommandPrivilegeChecker authorization) {
        this.authorization = authorization;
    }

    public Map<Long, CommandPrivilegeChecker> getUsers() {
        return users;
    }

    public void setUsers(Map<Long, CommandPrivilegeChecker> users) {
        this.users = users;
    }

    public Map<String, CommandPrivilegeChecker> getRoles() {
        return roles;
    }

    public void setRoles(Map<String, CommandPrivilegeChecker> roles) {
        this.roles = roles;
    }

    @Override
    public boolean check(SecurityContext securityContext, String commandType) {
        if (Objects.nonNull(unAuthorization) && unAuthorization.check(securityContext, commandType)) {
            return true;
        }

        var user = securityContext.getUser();
        if (Objects.isNull(user)) {
            return false;
        }

        if (Objects.nonNull(authorization) && authorization.check(securityContext, commandType)) {
            return true;
        }

        var userPrivilege = users.get(user.getId());
        if (Objects.nonNull(userPrivilege) && userPrivilege.check(securityContext, commandType)) {
            return true;
        }

        var rolePrivilege = roles.get(user.getRole());
        return Objects.nonNull(rolePrivilege) && rolePrivilege.check(securityContext, commandType);
    }
}
