package me.ahoo.pigeon.core.security.command.privilege;

import me.ahoo.pigeon.core.security.SecurityContext;

import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time 2020/10/16 22:23
 **/
public class PrivilegeSecurityChecker implements PrivilegeChecker {

    private PrivilegeGroup allow;
    private PrivilegeGroup disallow;

    @Override
    public boolean check(SecurityContext securityContext, String commandType) {
        if (Objects.nonNull(disallow)) {
            if (disallow.check(securityContext, commandType)) {
                return false;
            }
        }

        if (Objects.isNull(allow)) {
            return false;
        }

        return allow.check(securityContext, commandType);
    }

    public PrivilegeGroup getAllow() {
        return allow;
    }

    public void setAllow(PrivilegeGroup allow) {
        this.allow = allow;
    }

    public PrivilegeGroup getDisallow() {
        return disallow;
    }

    public void setDisallow(PrivilegeGroup disallow) {
        this.disallow = disallow;
    }


}
