package me.ahoo.pigeon.core.security.command.privilege.config;

import lombok.var;
import me.ahoo.pigeon.core.security.command.privilege.PrivilegeSecurityChecker;

import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time 2020/10/16 23:01
 **/
public class CommandSecurity {

    private PrivilegeConfig allow;
    private PrivilegeConfig disallow;

    public PrivilegeConfig getAllow() {
        return allow;
    }

    public void setAllow(PrivilegeConfig allow) {
        this.allow = allow;
    }

    public PrivilegeConfig getDisallow() {
        return disallow;
    }

    public void setDisallow(PrivilegeConfig disallow) {
        this.disallow = disallow;
    }

    public PrivilegeSecurityChecker asPrivilegeSecurityChecker() {
        var privilegeChecker = new PrivilegeSecurityChecker();
        if (Objects.nonNull(allow)) {
            privilegeChecker.setAllow(allow.asPrivilegeGroup());
        }
        if (Objects.nonNull(disallow)) {
            privilegeChecker.setDisallow(disallow.asPrivilegeGroup());
        }
        return privilegeChecker;
    }
}
