package me.ahoo.pigeon.core.security.command.privilege.config;

import lombok.var;
import me.ahoo.pigeon.core.security.command.mather.CommandMatcherFactory;
import me.ahoo.pigeon.core.security.command.privilege.CommandPrivilegeChecker;
import me.ahoo.pigeon.core.security.command.privilege.PrivilegeGroup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author ahoo wang
 * Creation time 2020/10/16 22:59
 **/
public class PrivilegeConfig {

    private List<String> unAuth;
    private List<String> auth;
    private Map<String, List<String>> role;
    private Map<Long, List<String>> user;

    public List<String> getUnAuth() {
        return unAuth;
    }

    public void setUnAuth(List<String> unAuth) {
        this.unAuth = unAuth;
    }

    public List<String> getAuth() {
        return auth;
    }

    public void setAuth(List<String> auth) {
        this.auth = auth;
    }

    public Map<String, List<String>> getRole() {
        return role;
    }

    public void setRole(Map<String, List<String>> role) {
        this.role = role;
    }

    public Map<Long, List<String>> getUser() {
        return user;
    }

    public void setUser(Map<Long, List<String>> user) {
        this.user = user;
    }

    /**
     * @return PrivilegeGroup
     */
    public PrivilegeGroup asPrivilegeGroup() {
        var privilegeGroup = new PrivilegeGroup();
        if (Objects.nonNull(unAuth) && !unAuth.isEmpty()) {
            var unAuthChecker = asCommandPrivilegeChecker(unAuth);
            privilegeGroup.setUnAuthorization(unAuthChecker);
        }

        if (Objects.nonNull(auth) && !auth.isEmpty()) {
            var authChecker = asCommandPrivilegeChecker(auth);
            privilegeGroup.setAuthorization(authChecker);
        }

        if (Objects.nonNull(role) && !role.isEmpty()) {
            Map<String, CommandPrivilegeChecker> roles = new HashMap<>(role.size());
            role.forEach((roleName, commands) -> {
                if (commands.isEmpty()) {
                    return;
                }
                roles.put(roleName, asCommandPrivilegeChecker(commands));
            });
            privilegeGroup.setRoles(roles);
        }

        if (Objects.nonNull(user) && !user.isEmpty()) {
            Map<Long, CommandPrivilegeChecker> users = new HashMap<>(user.size());
            user.forEach((userId, commands) -> {
                if (commands.isEmpty()) {
                    return;
                }
                users.put(userId, asCommandPrivilegeChecker(commands));
            });
            privilegeGroup.setUsers(users);
        }
        return privilegeGroup;
    }

    private CommandPrivilegeChecker asCommandPrivilegeChecker(List<String> commands) {
        var commandMatchers = commands.stream().map(commandMatch -> CommandMatcherFactory.of(commandMatch)).collect(Collectors.toList());
        return new CommandPrivilegeChecker(commandMatchers);
    }
}
