package me.ahoo.pigeon.core.security.device;


import lombok.var;
import me.ahoo.pigeon.core.id.impl.SecondSnowflakeId;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.authorization.Device;

import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time: 2019/12/12 0:26
 */
public class TemporaryDeviceRegistrar implements DeviceRegistrar {

    private final SecondSnowflakeId secondSnowflakeId;

    public TemporaryDeviceRegistrar(SecondSnowflakeId secondSnowflakeId) {
        this.secondSnowflakeId = secondSnowflakeId;
    }

    @Override
    public Device register(Message message) {
        var agent = message.getHeader().get(Device.AGENT);

        var deviceBuilder = Device.builder()
                .id(secondSnowflakeId.generate())
                .name("Browser-Device");

        if (Objects.nonNull(agent)) {
            deviceBuilder.agent(agent.toString());
        }
        return deviceBuilder.build();
    }
}
