package me.ahoo.pigeon.core.util;

/**
 * @author ahoo wang
 * Creation time: 2019/11/20 19:30
 */

import lombok.var;

import javax.annotation.Nullable;
import java.lang.reflect.ParameterizedType;

public abstract class Clazzs {

    public static <TGenericType> Class<TGenericType> getFirstClassGenericType(Class<?> subclass) {
        return getClassGenericTypeByIndex(subclass, 0);
    }

    public static <TGenericType> Class<TGenericType> getClassGenericTypeByIndex(Class<?> subclass, int typeArgIndex) {
        var genericSuperclass = subclass.getGenericSuperclass();
        var parameterizedType = ParameterizedType.class.cast(genericSuperclass);
        return (Class<TGenericType>) parameterizedType.getActualTypeArguments()[typeArgIndex];
    }

    @Nullable
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;

        try {
            cl = Thread.currentThread().getContextClassLoader();
        } catch (Throwable var3) {
        }

        if (cl == null) {
            cl = Clazzs.class.getClassLoader();
            if (cl == null) {
                try {
                    cl = ClassLoader.getSystemClassLoader();
                } catch (Throwable var2) {
                }
            }
        }
        return cl;
    }


}

