package me.ahoo.pigeon.core.util;

import lombok.var;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.RouteDirection;
import me.ahoo.pigeon.core.exception.ErrorCodes;
import me.ahoo.pigeon.core.exception.PigeonException;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/**
 * @author ahoo wang
 * Creation time 2020/10/15 21:35
 **/
public final class Messages {

    public static Message clientResponseOf(Message reqMsg) {
        var respMsg = Message.ofDirection(RouteDirection.CLIENT);
        var clientMsgId = reqMsg.getClientMessageId(true);
        return respMsg.setClientMessageId(clientMsgId);
    }

    public static Message clientErrorResponseOf(Message reqMsg, PigeonException pigeonException) {
        return clientResponseOf(reqMsg)
                .setErrorCode(pigeonException.getCode())
                .setErrorMsg(pigeonException.getMessage());
    }

    public static Message clientErrorResponseOf(Message reqMsg, Throwable throwable) {
        return clientResponseOf(reqMsg)
                .setErrorCode(ErrorCodes.UNKNOWN)
                .setErrorMsg(throwable.getMessage());
    }

    public static Class<?> getBodyClass(Method subscribeMethod) {
        var parameterType = subscribeMethod.getGenericParameterTypes()[0];
        return getBodyClass(parameterType);
    }

    public static Class<?> getBodyClass(Type parameterType) {
        if (parameterType instanceof ParameterizedType) {
            var parameterizedType = (ParameterizedType) parameterType;
            return (Class<?>) parameterizedType.getActualTypeArguments()[0];
        }

        if (!(parameterType instanceof Class) || Message.class.equals(parameterType)) {
            return String.class;
        }

        var msgClass = (Class) parameterType;

        return getBodyClass(msgClass.getGenericSuperclass());

    }
}
