package me.ahoo.pigeon.core.util;

import lombok.SneakyThrows;
import lombok.var;

import javax.annotation.Nonnull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

/**
 *
 * TODO use {@link com.google.common.io.Resources}
 * @author ahoo wang
 * Creation time: 2019/11/20 19:26
 */
public abstract class Resources {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";

    public Resources() {
    }

    @SneakyThrows
    public static InputStream getResource(@Nonnull String resourceLocation) {
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            return getClassPathResource(path);
        }

        if (resourceLocation.startsWith(FILE_URL_PREFIX)) {
            String path = resourceLocation.substring(FILE_URL_PREFIX.length());
            return getFileResource(path);
        }

        return new FileInputStream(resourceLocation);
    }

    @SneakyThrows
    public static InputStream getFileResource(String path) {
        var file = new File(path);
        return new FileInputStream(file);
    }

    @SneakyThrows
    public static InputStream getClassPathResource(String path) {
        ClassLoader cl = Clazzs.getDefaultClassLoader();
        URL url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
        if (url == null) {
            String description = "class path resource [" + path + "]";
            throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
        }
        return url.openStream();
    }
}
