package me.ahoo.pigeon.core.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import lombok.var;
import me.ahoo.pigeon.core.Constants;

import java.util.concurrent.ThreadFactory;

/**
 * @author ahoo wang
 * Creation time: 2019/12/4 17:44
 */
public class Threads {

    public static ThreadFactory defaultFactory(String domain) {
        var nameFormat = Constants.PIGEON + "-" + domain + "-%d";
        return new ThreadFactoryBuilder()
                .setDaemon(false)
                .setNameFormat(nameFormat)
                .build();
    }

    public static int defaultCorePoolSize() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

}
