/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.bus;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.util.Threads;

public interface Dispatcher {
    public static final Dispatcher DEFAULT = new Default();

    public void dispatch(Message var1, Set<Subscriber> var2);

    public static class Default
    implements Dispatcher {
        private final ExecutorService executorService;

        public Default() {
            ThreadFactory threadFactory = Threads.defaultFactory("Dispatcher-DEFAULT");
            int corePoolSize = Threads.defaultCorePoolSize();
            this.executorService = new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        }

        @Override
        public void dispatch(Message message, Set<Subscriber> subscribers) {
            subscribers.forEach(subscriber -> this.executorService.execute(() -> subscriber.invoke(message)));
        }
    }
}

