/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.bus.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import me.ahoo.pigeon.core.bus.TopicParser;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberDefinition;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.RouteDirection;

public class DefaultTopicParser
implements TopicParser {
    private final String topicPrefix;
    private final String connectorTopic;
    private final String connectorTopicFormat;
    private final String routerTopic;

    public DefaultTopicParser() {
        this("pigeon.");
    }

    public DefaultTopicParser(String topicPrefix) {
        this.topicPrefix = topicPrefix;
        this.routerTopic = topicPrefix + RouteDirection.ROUTER.name().toLowerCase();
        this.connectorTopic = topicPrefix + RouteDirection.CONNECTOR.name().toLowerCase();
        this.connectorTopicFormat = this.connectorTopic + ".%s";
    }

    @Override
    public String parseMessageTopic(Message message) {
        RouteDirection direction = message.getDirection(true);
        switch (direction) {
            case CONNECTOR: {
                Integer connectorId = message.getHeader().getReceiverConnectorId(false);
                if (Objects.nonNull(connectorId)) {
                    return Strings.lenientFormat((String)this.connectorTopicFormat, (Object[])new Object[]{connectorId});
                }
                return this.connectorTopic;
            }
            case COMMANDER: {
                return this.getCommanderTopic(message.getCommandType(true));
            }
            case ROUTER: {
                return this.routerTopic;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)direction));
    }

    @Override
    public Set<String> parseSubscriberTopic(SubscriberDefinition subscriberDefinition) {
        RouteDirection direction = subscriberDefinition.getDirection();
        switch (direction) {
            case CONNECTOR: {
                String topicOfConnectorId = Strings.lenientFormat((String)this.connectorTopicFormat, (Object[])new Object[]{subscriberDefinition.getConnectorId()});
                return Sets.newHashSet((Object[])new String[]{this.connectorTopic, topicOfConnectorId});
            }
            case COMMANDER: {
                String commandType = subscriberDefinition.getCommandType();
                return Sets.newHashSet((Object[])new String[]{this.getCommanderTopic(commandType)});
            }
            case ROUTER: {
                return Sets.newHashSet((Object[])new String[]{this.routerTopic});
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)direction));
    }

    protected String getCommanderTopic(String commandType) {
        return this.topicPrefix + commandType;
    }
}

