/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.bus.impl;

import com.google.common.base.Strings;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.ahoo.pigeon.core.bus.Dispatcher;
import me.ahoo.pigeon.core.bus.MessageBus;
import me.ahoo.pigeon.core.bus.MessageTopicParser;
import me.ahoo.pigeon.core.bus.PublishResult;
import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberRegistry;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.util.Futures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMessageBus
implements MessageBus {
    private static final Logger log = LoggerFactory.getLogger(MemoryMessageBus.class);
    private final Dispatcher dispatcher;
    private final MessageTopicParser messageTopicParser;
    private final SubscriberRegistry subscriberRegistry;

    public MemoryMessageBus(Dispatcher dispatcher, MessageTopicParser messageTopicParser, SubscriberRegistry subscriberRegistry) {
        this.dispatcher = dispatcher;
        this.messageTopicParser = messageTopicParser;
        this.subscriberRegistry = subscriberRegistry;
    }

    @Override
    public CompletableFuture<PublishResult> publish(Message message) {
        try {
            String topic = this.messageTopicParser.parseMessageTopic(message);
            Set<Subscriber> subscribers = this.subscriberRegistry.getSubscribers(topic);
            this.dispatcher.dispatch(message, subscribers);
            if (log.isDebugEnabled()) {
                log.debug("publish - message.id:[{}] ,direction:[{}],commandType:[{}]", new Object[]{message.getHeader().getId(false), message.getDirection(false), message.getCommandType(false)});
            }
            return CompletableFuture.completedFuture(new PublishResult(message));
        }
        catch (Throwable throwable) {
            log.error(Strings.lenientFormat((String)"publish - failed! -> id:[%s] ,direction:[%s],commandType:[%s]", (Object[])new Object[]{message.getHeader().getId(false), message.getDirection(false), message.getCommandType(false)}), throwable);
            return Futures.ofFailed(throwable);
        }
    }

    @Override
    public void subscribe(Subscriber subscriber) {
        this.subscriberRegistry.register(subscriber);
    }
}

