/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.bus.subscriber;

import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface ExceptionHandler {
    public static final ExceptionHandler LOGGER = new LoggerExceptionHandler();

    public void handle(Subscriber var1, Message var2, Throwable var3);

    public static class LoggerExceptionHandler
    implements ExceptionHandler {
        private static final Logger log = LoggerFactory.getLogger(LoggerExceptionHandler.class);

        @Override
        public void handle(Subscriber subscriber, Message message, Throwable exception) {
            String errorMsg = String.format("Exception thrown by subscriber method:[%s],on subscriber:[%s],when dispatching message->id:[%s] ,direction:[%s],commandType:[%s]", new Object[]{subscriber.getMethod().getName(), subscriber.getTarget().getClass().getName(), message.getHeader().getId(false), message.getDirection(false), message.getCommandType(false)});
            log.error(errorMsg, exception);
        }
    }
}

