/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.bus.subscriber;

import java.lang.reflect.Method;
import java.util.Set;
import me.ahoo.pigeon.core.bus.subscriber.ExceptionHandler;
import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.bus.subscriber.impl.DefaultSubscriber;
import me.ahoo.pigeon.core.message.RouteDirection;

public class SubscriberDefinition {
    private String name;
    private Object target;
    private Method method;
    private RouteDirection direction;
    private String commandType;
    private Set<String> topics;
    private String groupId;
    private Integer connectorId;
    private ExceptionHandler exceptionHandler;

    public SubscriberDefinition(String name, Object target, Method method, RouteDirection direction, String commandType, Set<String> topics, String groupId, Integer connectorId, ExceptionHandler exceptionHandler) {
        this.name = name;
        this.target = target;
        this.method = method;
        this.direction = direction;
        this.commandType = commandType;
        this.topics = topics;
        this.groupId = groupId;
        this.connectorId = connectorId;
        this.exceptionHandler = exceptionHandler;
    }

    public static SubscriberDefinitionBuilder builder() {
        return new SubscriberDefinitionBuilder();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public RouteDirection getDirection() {
        return this.direction;
    }

    public void setDirection(RouteDirection direction) {
        this.direction = direction;
    }

    public String getCommandType() {
        return this.commandType;
    }

    public void setCommandType(String commandType) {
        this.commandType = commandType;
    }

    public Set<String> getTopics() {
        return this.topics;
    }

    public void setTopics(Set<String> topics) {
        this.topics = topics;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Integer getConnectorId() {
        return this.connectorId;
    }

    public void setConnectorId(Integer connectorId) {
        this.connectorId = connectorId;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Subscriber asSubscriber() {
        return new DefaultSubscriber(this.name, this.target, this.method, this.direction, this.commandType, this.groupId, this.topics, this.connectorId, this.exceptionHandler);
    }

    public static class SubscriberDefinitionBuilder {
        private String name;
        private Object target;
        private Method method;
        private RouteDirection direction;
        private String commandType;
        private Set<String> topics;
        private String groupId;
        private Integer connectorId;
        private ExceptionHandler exceptionHandler;

        SubscriberDefinitionBuilder() {
        }

        public SubscriberDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SubscriberDefinitionBuilder target(Object target) {
            this.target = target;
            return this;
        }

        public SubscriberDefinitionBuilder method(Method method) {
            this.method = method;
            return this;
        }

        public SubscriberDefinitionBuilder direction(RouteDirection direction) {
            this.direction = direction;
            return this;
        }

        public SubscriberDefinitionBuilder commandType(String commandType) {
            this.commandType = commandType;
            return this;
        }

        public SubscriberDefinitionBuilder topics(Set<String> topics) {
            this.topics = topics;
            return this;
        }

        public SubscriberDefinitionBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public SubscriberDefinitionBuilder connectorId(Integer connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public SubscriberDefinitionBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public SubscriberDefinition build() {
            return new SubscriberDefinition(this.name, this.target, this.method, this.direction, this.commandType, this.topics, this.groupId, this.connectorId, this.exceptionHandler);
        }

        public String toString() {
            return "SubscriberDefinition.SubscriberDefinitionBuilder(name=" + this.name + ", target=" + this.target + ", method=" + this.method + ", direction=" + (Object)((Object)this.direction) + ", commandType=" + this.commandType + ", topics=" + this.topics + ", groupId=" + this.groupId + ", connectorId=" + this.connectorId + ", exceptionHandler=" + this.exceptionHandler + ")";
        }
    }
}

