/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.bus.subscriber.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import me.ahoo.pigeon.core.bus.subscriber.ExceptionHandler;
import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.RouteDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubscriber
implements Subscriber {
    private static final Logger log = LoggerFactory.getLogger(DefaultSubscriber.class);
    private final String name;
    private final Object target;
    private final Method method;
    private final RouteDirection direction;
    private final String commandType;
    private final String groupId;
    private final Set<String> topics;
    private final Integer connectorId;
    private final ExceptionHandler exceptionHandler;

    public DefaultSubscriber(String name, Object target, Method method, RouteDirection direction, String commandType, String groupId, Set<String> topics, Integer connectorId, ExceptionHandler exceptionHandler) {
        Preconditions.checkNotNull((Object)name, (Object)"name can not be null!");
        Preconditions.checkNotNull((Object)target, (Object)"target can not be null!");
        Preconditions.checkNotNull((Object)method, (Object)"method can not be null!");
        Preconditions.checkState((Objects.nonNull((Object)direction) && !RouteDirection.NULL.equals((Object)direction) ? 1 : 0) != 0, (Object)"direction can not be null!");
        if (RouteDirection.COMMANDER.equals((Object)direction)) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)commandType) ? 1 : 0) != 0, (Object)"the commandType can not be null or empty  when the direction is {@link RouteDirection#COMMANDER}!");
        }
        Preconditions.checkState((Objects.nonNull(topics) && !topics.isEmpty() ? 1 : 0) != 0, (Object)"topics can not be null or empty!");
        Preconditions.checkState((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"groupId can not be null or empty!");
        if (RouteDirection.CONNECTOR.equals((Object)direction)) {
            Preconditions.checkState((boolean)Objects.nonNull(connectorId), (Object)"the connectorId can not be null when the direction is {@link RouteDirection#CONNECTOR}!");
        }
        this.name = name;
        this.target = target;
        this.method = method;
        if (!this.method.isAccessible()) {
            this.method.setAccessible(true);
        }
        this.direction = direction;
        this.commandType = commandType;
        this.topics = topics;
        this.groupId = groupId;
        this.connectorId = connectorId;
        this.exceptionHandler = (ExceptionHandler)MoreObjects.firstNonNull((Object)exceptionHandler, (Object)ExceptionHandler.LOGGER);
    }

    @Override
    public void invoke(Message message) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("invoke -> [{}] .", (Object)message);
            }
            this.method.invoke(this.target, message);
        }
        catch (InvocationTargetException invocationTargetEx) {
            this.exceptionHandler.handle(this, message, invocationTargetEx.getTargetException());
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(this, message, ex);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public RouteDirection getDirection() {
        return this.direction;
    }

    @Override
    public String getCommandType() {
        return this.commandType;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public Set<String> getTopics() {
        return this.topics;
    }

    @Override
    public Integer getConnectorId() {
        return this.connectorId;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public String toString() {
        return this.name;
    }
}

