/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.bus.subscriber.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.ahoo.pigeon.core.bus.Subscribe;
import me.ahoo.pigeon.core.bus.subscriber.ExceptionHandler;
import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberDefinition;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberFactory;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberGroupIdParser;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberTopicParser;
import me.ahoo.pigeon.core.connector.ConnectorId;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.RouteDirection;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultSubscriberFactory
implements SubscriberFactory {
    private static final int ONE = 1;
    private final ConnectorId connectorId;
    private final SubscriberGroupIdParser subscriberGroupIdParser;
    private final SubscriberTopicParser subscriberTopicParser;
    private final ExceptionHandler exceptionHandler;

    public DefaultSubscriberFactory(ConnectorId connectorId, SubscriberGroupIdParser subscriberGroupIdParser, SubscriberTopicParser subscriberTopicParser, ExceptionHandler exceptionHandler) {
        this.connectorId = connectorId;
        this.subscriberGroupIdParser = subscriberGroupIdParser;
        this.subscriberTopicParser = subscriberTopicParser;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public List<Subscriber> getSubscribers(Object targetObj) {
        return this.parse(targetObj).stream().map(this::getSubscriber).collect(Collectors.toList());
    }

    private List<SubscriberDefinition> parse(Object targetObj) {
        Preconditions.checkNotNull((Object)targetObj);
        Class targetClass = AopUtils.getTargetClass((Object)targetObj);
        Subscribe classSubscribe = (Subscribe)AnnotationUtils.findAnnotation((Class)targetClass, Subscribe.class);
        ArrayList<SubscriberDefinition> subscriberDefinitions = new ArrayList<SubscriberDefinition>();
        ReflectionUtils.doWithMethods((Class)targetClass, method -> {
            Subscribe methodSubscribe = (Subscribe)AnnotationUtils.getAnnotation((Method)method, Subscribe.class);
            if (Objects.isNull(methodSubscribe)) {
                return;
            }
            Preconditions.checkState((method.getParameterCount() == 1 ? 1 : 0) != 0, (String)"method:[%s] ParameterCount must be 1.", (Object)method);
            Class<?> firstParameterType = method.getParameterTypes()[0];
            Preconditions.checkState((boolean)Message.class.isAssignableFrom(firstParameterType), (Object)"method:[%s] parameter.Type must be Message.");
            SubscriberDefinition subscriberDefinition = this.parseMethod(targetObj, method, methodSubscribe, classSubscribe);
            subscriberDefinitions.add(subscriberDefinition);
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return subscriberDefinitions;
    }

    private SubscriberDefinition parseMethod(Object targetObject, Method method, Subscribe methodSubscribe, Subscribe classSubscribe) {
        SubscriberDefinition.SubscriberDefinitionBuilder definitionBuilder = SubscriberDefinition.builder().target(targetObject).method(method).exceptionHandler(this.exceptionHandler);
        String name = methodSubscribe.name();
        if (Objects.nonNull(classSubscribe) && !Strings.isNullOrEmpty((String)classSubscribe.name())) {
            name = classSubscribe.name() + methodSubscribe.name();
        }
        if (Strings.isNullOrEmpty((String)name)) {
            name = this.generateSubscriberName(method);
        }
        definitionBuilder.name(name);
        RouteDirection direction = methodSubscribe.direction();
        if (RouteDirection.NULL.equals((Object)direction)) {
            Preconditions.checkNotNull((Object)classSubscribe);
            Preconditions.checkState((!RouteDirection.NULL.equals((Object)classSubscribe.direction()) ? 1 : 0) != 0);
            direction = classSubscribe.direction();
        }
        definitionBuilder.direction(direction);
        if (RouteDirection.CONNECTOR.equals((Object)direction)) {
            definitionBuilder.connectorId(this.connectorId.getId());
        }
        String commandType = methodSubscribe.commandType();
        if (Objects.nonNull(classSubscribe) && !Strings.isNullOrEmpty((String)classSubscribe.commandType())) {
            commandType = classSubscribe.commandType() + methodSubscribe.commandType();
        }
        definitionBuilder.commandType(commandType);
        SubscriberDefinition subscriberDefinition = definitionBuilder.build();
        String groupId = methodSubscribe.groupId();
        if (Strings.isNullOrEmpty((String)groupId)) {
            groupId = this.subscriberGroupIdParser.parseGroupId(subscriberDefinition);
        }
        if (Objects.nonNull(classSubscribe) && !Strings.isNullOrEmpty((String)classSubscribe.groupId())) {
            groupId = classSubscribe.groupId() + groupId;
        }
        subscriberDefinition.setGroupId(groupId);
        Set<String> topics = this.subscriberTopicParser.parseSubscriberTopic(subscriberDefinition);
        subscriberDefinition.setTopics(topics);
        return subscriberDefinition;
    }

    private String generateSubscriberName(Method subscribeMethod) {
        return subscribeMethod.getName() + "@" + subscribeMethod.getDeclaringClass().getName();
    }

    public Subscriber getSubscriber(SubscriberDefinition subscriberDefinition) {
        return subscriberDefinition.asSubscriber();
    }
}

