/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.bus.subscriber.impl;

import com.google.common.base.Strings;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberDefinition;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberGroupIdParser;
import me.ahoo.pigeon.core.message.RouteDirection;

public class DefaultSubscriberGroupIdParser
implements SubscriberGroupIdParser {
    private final String groupPrefix;
    private final String connectorGroupIdFormat;
    private final String routerGroupId;

    public DefaultSubscriberGroupIdParser() {
        this("pigeon.");
    }

    public DefaultSubscriberGroupIdParser(String groupPrefix) {
        this.groupPrefix = groupPrefix;
        this.routerGroupId = groupPrefix + RouteDirection.ROUTER.name().toLowerCase();
        this.connectorGroupIdFormat = groupPrefix + RouteDirection.CONNECTOR.name().toLowerCase() + ".%s";
    }

    @Override
    public String parseGroupId(SubscriberDefinition subscriberDefinition) {
        if (!Strings.isNullOrEmpty((String)subscriberDefinition.getGroupId())) {
            return subscriberDefinition.getGroupId();
        }
        RouteDirection direction = subscriberDefinition.getDirection();
        switch (direction) {
            case CONNECTOR: {
                return Strings.lenientFormat((String)this.connectorGroupIdFormat, (Object[])new Object[]{subscriberDefinition.getConnectorId()});
            }
            case ROUTER: {
                return this.routerGroupId;
            }
            case COMMANDER: {
                return this.groupPrefix + subscriberDefinition.getCommandType();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)direction));
    }
}

