/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.codec;

import com.google.common.base.Strings;
import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.pigeon.core.bus.subscriber.Subscriber;
import me.ahoo.pigeon.core.codec.StringToMessageDecoder;
import me.ahoo.pigeon.core.codec.decoder.CustomizeBodyMessageDecoder;
import me.ahoo.pigeon.core.codec.decoder.NoneMessageDecoder;
import me.ahoo.pigeon.core.codec.decoder.StringBodyMessageDecoder;
import me.ahoo.pigeon.core.util.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderRegistrar {
    private static final Logger log = LoggerFactory.getLogger(DecoderRegistrar.class);
    private ConcurrentHashMap<String, StringToMessageDecoder> typeDecoders = new ConcurrentHashMap();

    public DecoderRegistrar() {
        this.register("client_ack", NoneMessageDecoder.INSTANCE);
        this.register("server_ack", NoneMessageDecoder.INSTANCE);
        this.register("heartbeat", NoneMessageDecoder.INSTANCE);
        this.register("auth", NoneMessageDecoder.INSTANCE);
    }

    public void register(String commandType, StringToMessageDecoder messageDecoder) {
        StringToMessageDecoder beforeVal = this.typeDecoders.put(commandType, messageDecoder);
        if (log.isInfoEnabled()) {
            log.info("register - commandType:[{}] , messageDecoder:[{}] , before:[{}]", new Object[]{commandType, messageDecoder.getClass().getName(), beforeVal});
        }
    }

    public void register(Subscriber subscriber) {
        String commandType = subscriber.getCommandType();
        if (Strings.isNullOrEmpty((String)commandType)) {
            if (log.isInfoEnabled()) {
                log.info("register - Ignore :commandType is null or empty, subscriber:[{}]", (Object)subscriber);
            }
            return;
        }
        this.typeDecoders.computeIfAbsent(commandType, cmdType -> {
            Class<?> bodyClass = Messages.getBodyClass(subscriber.getMethod());
            if (String.class.equals(bodyClass)) {
                if (log.isInfoEnabled()) {
                    log.info("register - commandType:[{}] , bodyClass:[{}], messageDecoder:[StringBodyMessageDecoder.INSTANCE].", (Object)commandType, (Object)bodyClass.getName());
                }
                return StringBodyMessageDecoder.INSTANCE;
            }
            if (Void.class.equals(bodyClass)) {
                if (log.isInfoEnabled()) {
                    log.info("register - commandType:[{}] , bodyClass:[{}], messageDecoder:[NoneMessageDecoder.INSTANCE].", (Object)commandType, (Object)bodyClass.getName());
                }
                return NoneMessageDecoder.INSTANCE;
            }
            if (log.isInfoEnabled()) {
                log.info("register - commandType:[{}] , bodyClass:[{}] with CustomizeBodyMessageDecoder.", (Object)commandType, (Object)bodyClass.getName());
            }
            return new CustomizeBodyMessageDecoder(bodyClass);
        });
    }

    public boolean contains(String commandType) {
        return this.typeDecoders.containsKey(commandType);
    }

    public StringToMessageDecoder find(String commandType) {
        return this.typeDecoders.getOrDefault(commandType, StringBodyMessageDecoder.INSTANCE);
    }
}

