/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import me.ahoo.pigeon.core.codec.MessageEncoder;
import me.ahoo.pigeon.core.codec.StringMessageBag;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.MessageHeader;
import me.ahoo.pigeon.core.util.ObjectMappers;

public class MessageToStringEncoder
implements MessageEncoder<Object, String, String, String> {
    private final ObjectMapper objectMapper = ObjectMappers.of();

    @Override
    public String encode(Message message) {
        StringMessageBag stringMessageBag = new StringMessageBag();
        String headerStr = this.encodeHeader(message.getHeader());
        stringMessageBag.setHeader(headerStr);
        String bodyStr = this.encodeBody(message.getBody());
        stringMessageBag.setBody(bodyStr);
        return stringMessageBag.toSource();
    }

    @Override
    public String encodeHeader(MessageHeader messageHeader) {
        return this.objectMapper.writeValueAsString((Object)messageHeader);
    }

    @Override
    public String encodeBody(Object messageBody) {
        if (Objects.isNull(messageBody)) {
            return null;
        }
        if (String.class.isInstance(messageBody)) {
            return messageBody.toString();
        }
        return this.objectMapper.writeValueAsString(messageBody);
    }
}

