/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.codec;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import me.ahoo.pigeon.core.codec.SourceMessageBag;

public class StringMessageBag
implements SourceMessageBag<String, String, String> {
    public static final String HEADER_SEPARATOR_BODY = "\n";
    private static final int TWO = 2;
    private String header;
    private String body;

    public StringMessageBag() {
    }

    public StringMessageBag(String messageStr) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)messageStr) ? 1 : 0) != 0, (Object)"messageStr can not be empty.");
        String[] messages = messageStr.split(HEADER_SEPARATOR_BODY, 2);
        this.header = messages[0];
        this.body = messages.length == 2 ? messages[1] : null;
    }

    @Override
    public String toSource() {
        if (Objects.isNull(this.body)) {
            return this.header;
        }
        return this.header + HEADER_SEPARATOR_BODY + this.body;
    }

    public String toString() {
        return "StringMessageBag{header='" + this.header + '\'' + ", body='" + this.body + '\'' + '}';
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(String header) {
        this.header = header;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }
}

