/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import me.ahoo.pigeon.core.codec.MessageDecoder;
import me.ahoo.pigeon.core.codec.StringMessageBag;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.MessageHeader;
import me.ahoo.pigeon.core.util.Clazzs;
import me.ahoo.pigeon.core.util.ObjectMappers;

public abstract class StringToMessageDecoder<TBody>
implements MessageDecoder<TBody, String, String, String> {
    protected final ObjectMapper objectMapper;
    private final Class<TBody> bodyClass;
    private final boolean noneBody;

    public StringToMessageDecoder() {
        this(ObjectMappers.of(), null);
    }

    public StringToMessageDecoder(ObjectMapper objectMapper, Class<TBody> bodyClass) {
        this.objectMapper = objectMapper;
        if (Objects.isNull(bodyClass)) {
            bodyClass = Clazzs.getFirstClassGenericType(this.getClass());
        }
        this.bodyClass = bodyClass;
        this.noneBody = bodyClass.equals(Void.class);
    }

    @Override
    public Message<TBody> decode(String source) {
        Preconditions.checkNotNull((Object)source);
        StringMessageBag sourceMessageBag = new StringMessageBag(source);
        Message<TBody> msgObj = new Message<TBody>();
        MessageHeader header = this.decodeHeader(sourceMessageBag.getHeader());
        msgObj.setHeader(header);
        if (this.noneBody) {
            return msgObj;
        }
        TBody body = this.decodeBody(header, sourceMessageBag.getBody());
        if (Objects.nonNull(body)) {
            msgObj.setBody(body);
        }
        return msgObj;
    }

    @Override
    public MessageHeader decodeHeader(String headerStr) {
        return (MessageHeader)this.objectMapper.readValue(headerStr, MessageHeader.class);
    }

    @Override
    public TBody decodeBody(MessageHeader header, String bodyStr) {
        if (Strings.isNullOrEmpty((String)bodyStr)) {
            return null;
        }
        if (this.bodyClass.isInstance(bodyStr)) {
            return (TBody)bodyStr;
        }
        return (TBody)this.objectMapper.readValue(bodyStr, this.bodyClass);
    }
}

