/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.id.impl;

import me.ahoo.pigeon.core.Constants;
import me.ahoo.pigeon.core.id.impl.MillisecondSnowflakeId;
import me.ahoo.pigeon.core.id.impl.SecondSnowflakeId;

public class SafeJavaScriptSnowflakeId {
    public static final int JAVA_SCRIPT_MAX_SAFE_NUMBER_BIT = 53;
    public static final long JAVA_SCRIPT_MAX_SAFE_NUMBER = 0x1FFFFFFFFFFFFFL;

    public static MillisecondSnowflakeId ofMillisecond(long epoch, int timestampBit, int machineBit, int sequenceBit, int machineId) {
        SafeJavaScriptSnowflakeId.checkTotalBit(timestampBit, machineBit, sequenceBit);
        return new MillisecondSnowflakeId(epoch, timestampBit, machineBit, sequenceBit, machineId);
    }

    public static SecondSnowflakeId ofSecond(long epoch, int timestampBit, int machineBit, int sequenceBit, int machineId) {
        SafeJavaScriptSnowflakeId.checkTotalBit(timestampBit, machineBit, sequenceBit);
        return new SecondSnowflakeId(epoch, timestampBit, machineBit, sequenceBit, machineId);
    }

    public static MillisecondSnowflakeId ofMillisecond(int machineId) {
        int timestampBit = 41;
        int machineBit = 6;
        int sequenceBit = 6;
        SafeJavaScriptSnowflakeId.checkTotalBit(timestampBit, machineBit, sequenceBit);
        return SafeJavaScriptSnowflakeId.ofMillisecond(Constants.PIGEON_EPOCH_SECOND, timestampBit, machineBit, sequenceBit, machineId);
    }

    public static SecondSnowflakeId ofSecond(int machineId) {
        int timestampBit = 31;
        int machineBit = 6;
        int sequenceBit = 16;
        SafeJavaScriptSnowflakeId.checkTotalBit(timestampBit, machineBit, sequenceBit);
        return SafeJavaScriptSnowflakeId.ofSecond(Constants.PIGEON_EPOCH_SECOND, timestampBit, machineBit, sequenceBit, machineId);
    }

    private static void checkTotalBit(int timestampBit, int machineBit, int sequenceBit) {
        if (timestampBit + machineBit + sequenceBit > 53) {
            throw new IllegalArgumentException(String.format("total bit can't be greater than JAVA_SCRIPT_MAX_SAFE_NUMBER_BIT:[%s].", 53));
        }
    }
}

