/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.id.impl;

import com.google.common.base.Strings;
import me.ahoo.pigeon.core.id.IdGenerator;

public abstract class SnowflakeId
implements IdGenerator {
    public static final int TOTAL_BIT = 63;
    protected final long epoch;
    protected final int timestampBit;
    protected final int machineBit;
    protected final int sequenceBit;
    protected final long maxTimestamp;
    protected final long maxSequence;
    protected final long maxMachine;
    protected final long machineLeft;
    protected final long timestampLeft;
    protected final int machineId;
    protected long sequence = 0L;
    protected long lastStamp = -1L;

    public SnowflakeId(long epoch, int timestampBit, int machineBit, int sequenceBit, int machineId) {
        if (timestampBit + machineBit + sequenceBit > 63) {
            throw new IllegalArgumentException("total bit can't be greater than TOTAL_BIT[63] .");
        }
        this.epoch = epoch;
        this.timestampBit = timestampBit;
        this.machineBit = machineBit;
        this.sequenceBit = sequenceBit;
        this.maxTimestamp = 0xFFFFFFFFFFFFFFFFL ^ -1L << timestampBit;
        this.maxSequence = 0xFFFFFFFFFFFFFFFFL ^ -1L << sequenceBit;
        this.maxMachine = 0xFFFFFFFFFFFFFFFFL ^ -1L << machineBit;
        this.machineLeft = sequenceBit;
        this.timestampLeft = this.machineLeft + (long)machineBit;
        if ((long)machineId > this.maxMachine || machineId < 0) {
            throw new IllegalArgumentException("machineId can't be greater than maxMachine or less than 0 .");
        }
        this.machineId = machineId;
    }

    protected long nextTime() {
        long time = this.getCurrentTime();
        while (time <= this.lastStamp) {
            time = this.getCurrentTime();
        }
        return time;
    }

    protected abstract long getCurrentTime();

    @Override
    public synchronized long generate() {
        long currentStamp = this.getCurrentTime();
        if (currentStamp < this.lastStamp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currentStamp == this.lastStamp) {
            this.sequence = this.sequence + 1L & this.maxSequence;
            if (this.sequence == 0L) {
                currentStamp = this.nextTime();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStamp = currentStamp;
        long diffStamp = currentStamp - this.epoch;
        if (diffStamp > this.maxTimestamp) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"diffStamp:[%s] can't be greater than maxTimestamp:[%s]", (Object[])new Object[]{diffStamp, this.maxTimestamp}));
        }
        return diffStamp << (int)this.timestampLeft | (long)(this.machineId << (int)this.machineLeft) | this.sequence;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public int getTimestampBit() {
        return this.timestampBit;
    }

    public int getMachineBit() {
        return this.machineBit;
    }

    public int getSequenceBit() {
        return this.sequenceBit;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getMaxMachine() {
        return this.maxMachine;
    }

    public long getMaxSequence() {
        return this.maxSequence;
    }
}

