/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.id.impl;

import java.time.LocalDateTime;
import java.util.Objects;

public class SnowflakeIdState {
    private final long id;
    private final int machineId;
    private final long sequence;
    private final LocalDateTime timestamp;
    private final String friendlyId;

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (Objects.isNull(other) || !this.getClass().isInstance(other)) {
            return false;
        }
        SnowflakeIdState that = (SnowflakeIdState)other;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return this.friendlyId;
    }

    SnowflakeIdState(long id, int machineId, long sequence, LocalDateTime timestamp, String friendlyId) {
        this.id = id;
        this.machineId = machineId;
        this.sequence = sequence;
        this.timestamp = timestamp;
        this.friendlyId = friendlyId;
    }

    public static SnowflakeIdStateBuilder builder() {
        return new SnowflakeIdStateBuilder();
    }

    public long getId() {
        return this.id;
    }

    public int getMachineId() {
        return this.machineId;
    }

    public long getSequence() {
        return this.sequence;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getFriendlyId() {
        return this.friendlyId;
    }

    public static class SnowflakeIdStateBuilder {
        private long id;
        private int machineId;
        private long sequence;
        private LocalDateTime timestamp;
        private String friendlyId;

        SnowflakeIdStateBuilder() {
        }

        public SnowflakeIdStateBuilder id(long id) {
            this.id = id;
            return this;
        }

        public SnowflakeIdStateBuilder machineId(int machineId) {
            this.machineId = machineId;
            return this;
        }

        public SnowflakeIdStateBuilder sequence(long sequence) {
            this.sequence = sequence;
            return this;
        }

        public SnowflakeIdStateBuilder timestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SnowflakeIdStateBuilder friendlyId(String friendlyId) {
            this.friendlyId = friendlyId;
            return this;
        }

        public SnowflakeIdState build() {
            return new SnowflakeIdState(this.id, this.machineId, this.sequence, this.timestamp, this.friendlyId);
        }

        public String toString() {
            return "SnowflakeIdState.SnowflakeIdStateBuilder(id=" + this.id + ", machineId=" + this.machineId + ", sequence=" + this.sequence + ", timestamp=" + this.timestamp + ", friendlyId=" + this.friendlyId + ")";
        }
    }
}

