/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.id.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import me.ahoo.pigeon.core.id.impl.MillisecondSnowflakeIdStateParser;
import me.ahoo.pigeon.core.id.impl.SecondSnowflakeId;
import me.ahoo.pigeon.core.id.impl.SecondSnowflakeIdStateParser;
import me.ahoo.pigeon.core.id.impl.SnowflakeId;
import me.ahoo.pigeon.core.id.impl.SnowflakeIdState;

public abstract class SnowflakeIdStateParser {
    public static final String DELIMITER = "-";
    protected final long epoch;
    protected final int sequenceBit;
    protected final long sequenceMask;
    protected final int machineBit;
    protected final long machineMask;
    protected final int machineLeft;
    protected final int timestampBit;
    protected final long timestampMask;
    protected final int timestampLeft;

    public SnowflakeIdStateParser(long epoch, int timestampBit, int machineBit, int sequenceBit) {
        this.epoch = epoch;
        this.sequenceMask = this.getMask(sequenceBit);
        this.sequenceBit = sequenceBit;
        this.machineMask = this.getMask(machineBit);
        this.machineBit = machineBit;
        this.timestampMask = this.getMask(timestampBit);
        this.timestampBit = timestampBit;
        this.machineLeft = sequenceBit;
        this.timestampLeft = this.machineLeft + machineBit;
    }

    protected abstract DateTimeFormatter getDateTimeFormatter();

    protected abstract LocalDateTime getTimestamp(long var1);

    protected abstract long getDiffTime(LocalDateTime var1);

    public SnowflakeIdState parse(String friendlyId) {
        Preconditions.checkNotNull((Object)friendlyId, (Object)"friendlyId can not be null!");
        List segments = Splitter.on((String)DELIMITER).trimResults().omitEmptyStrings().splitToList((CharSequence)friendlyId);
        if (segments.size() != 3) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"friendlyId :[%s] Illegal.", (Object[])new Object[]{friendlyId}));
        }
        String timestampStr = (String)segments.get(0);
        LocalDateTime timestamp = LocalDateTime.parse(timestampStr, this.getDateTimeFormatter());
        int machineId = Integer.parseInt((String)segments.get(1));
        long sequence = Long.parseLong((String)segments.get(2));
        long diffTime = this.getDiffTime(timestamp);
        long id = diffTime << this.timestampLeft | (long)(machineId << this.machineLeft) | sequence;
        return SnowflakeIdState.builder().id(id).machineId(machineId).sequence(sequence).timestamp(timestamp).friendlyId(friendlyId).build();
    }

    public SnowflakeIdState parse(long id) {
        long machineId = id >> this.machineLeft & this.machineMask;
        long sequence = id & this.sequenceMask;
        long diffTime = id >> this.timestampLeft & this.timestampMask;
        LocalDateTime timestamp = this.getTimestamp(diffTime);
        String friendlyId = timestamp.format(this.getDateTimeFormatter()) + DELIMITER + machineId + DELIMITER + sequence;
        return SnowflakeIdState.builder().id(id).machineId((int)machineId).sequence(sequence).timestamp(timestamp).friendlyId(friendlyId).build();
    }

    private long getMask(long bits) {
        return 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)bits;
    }

    public static SnowflakeIdStateParser of(SnowflakeId snowflakeId) {
        if (SecondSnowflakeId.class.isInstance(snowflakeId)) {
            return SecondSnowflakeIdStateParser.of(snowflakeId);
        }
        return MillisecondSnowflakeIdStateParser.of(snowflakeId);
    }
}

