/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.message;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import me.ahoo.pigeon.core.message.MessageHeader;
import me.ahoo.pigeon.core.message.RouteDirection;
import me.ahoo.pigeon.core.message.SendMode;

public final class Message<TBody>
implements Cloneable {
    private MessageHeader header;
    private TBody body;

    public Message<TBody> setHeader(MessageHeader header) {
        this.header = header;
        return this;
    }

    public Message<TBody> setBody(TBody body) {
        this.body = body;
        return this;
    }

    public RouteDirection getDirection(boolean required) {
        this.checkHeader();
        return this.header.getDirection(required);
    }

    private void checkHeader() {
        Preconditions.checkNotNull((Object)this.header, (Object)"header can not be null.");
    }

    public Message<TBody> setDirection(RouteDirection routeDirection) {
        this.checkHeader();
        this.header.setDirection(routeDirection);
        return this;
    }

    public String getCommandType(boolean required) {
        this.checkHeader();
        return this.header.getCommandType(required);
    }

    public Message<TBody> setCommandType(String commandType) {
        this.checkHeader();
        this.header.setCommandType(commandType);
        return this;
    }

    public Long getId(boolean required) {
        this.checkHeader();
        return this.header.getId(required);
    }

    public Message<TBody> setId(Long id) {
        this.checkHeader();
        this.header.setId(id);
        return this;
    }

    public SendMode getSendMode(boolean required) {
        this.checkHeader();
        return this.header.getSendMode(required);
    }

    public Message<TBody> setSendMode(SendMode sendMode) {
        this.checkHeader();
        this.header.setSendMode(sendMode);
        return this;
    }

    public String getApp(boolean required) {
        this.checkHeader();
        return this.header.getApp(required);
    }

    public Message<TBody> setApp(String app) {
        this.checkHeader();
        this.header.setApp(app);
        return this;
    }

    public String getErrorCode(boolean required) {
        this.checkHeader();
        return this.header.getErrorCode(required);
    }

    public Message<TBody> setErrorCode(String errorCode) {
        this.checkHeader();
        this.header.setErrorCode(errorCode);
        return this;
    }

    public String getErrorMsg(boolean required) {
        this.checkHeader();
        return this.header.getErrorMsg(required);
    }

    public Message<TBody> setErrorMsg(String errorCode) {
        this.checkHeader();
        this.header.setErrorMsg(errorCode);
        return this;
    }

    public String getFilterExpression(boolean required) {
        this.checkHeader();
        return this.header.getFilterExpression(required);
    }

    public Message<TBody> setFilterExpression(String filterExpression) {
        this.checkHeader();
        this.header.setFilterExpression(filterExpression);
        return this;
    }

    public String getClientMessageId(boolean required) {
        this.checkHeader();
        return this.header.getClientMessageId(required);
    }

    public Message<TBody> setClientMessageId(String clientMessageId) {
        this.checkHeader();
        this.header.setClientMessageId(clientMessageId);
        return this;
    }

    public Long getServerMessageId(boolean required) {
        this.checkHeader();
        return this.header.getServerMessageId(required);
    }

    public Message<TBody> setServerMessageId(Long serverMessageId) {
        this.checkHeader();
        this.header.setServerMessageId(serverMessageId);
        return this;
    }

    public boolean isRetry() {
        this.checkHeader();
        return this.header.isRetry();
    }

    public Integer getRetryTimes(boolean required) {
        this.checkHeader();
        return this.header.getRetryTimes(required);
    }

    public Message<TBody> setRetryTimes(Integer retryTimes) {
        this.checkHeader();
        this.header.setRetryTimes(retryTimes);
        return this;
    }

    public String getSenderChannelId(boolean required) {
        this.checkHeader();
        return this.header.getSenderChannelId(required);
    }

    public Message<TBody> setSenderChannelId(String senderChannelId) {
        this.checkHeader();
        this.header.setSenderChannelId(senderChannelId);
        return this;
    }

    public Long getSenderDeviceId(boolean required) {
        this.checkHeader();
        return this.header.getSenderDeviceId(required);
    }

    public Message<TBody> setSenderDeviceId(Long senderDeviceId) {
        this.checkHeader();
        this.header.setSenderDeviceId(senderDeviceId);
        return this;
    }

    public Long getSenderUserId(boolean required) {
        this.checkHeader();
        return this.header.getSenderUserId(required);
    }

    public Message<TBody> setSenderUserId(Long senderUserId) {
        this.checkHeader();
        this.header.setSenderUserId(senderUserId);
        return this;
    }

    public Integer getSenderConnectorId(boolean required) {
        this.checkHeader();
        return this.header.getSenderConnectorId(required);
    }

    public Message<TBody> setSenderConnectorId(Integer senderConnectorId) {
        this.checkHeader();
        this.header.setSenderConnectorId(senderConnectorId);
        return this;
    }

    public Long getCreateTime(boolean required) {
        this.checkHeader();
        return this.header.getCreateTime(required);
    }

    public Message<TBody> setCreateTime(Long createTime) {
        this.checkHeader();
        this.header.setCreateTime(createTime);
        return this;
    }

    public Message<TBody> ofNow() {
        this.checkHeader();
        this.header.ofNow();
        return this;
    }

    public String getReceiverChannelId(boolean required) {
        this.checkHeader();
        return this.header.getReceiverChannelId(required);
    }

    public Message<TBody> setReceiverChannelId(String receiverChannelId) {
        this.checkHeader();
        this.header.setReceiverChannelId(receiverChannelId);
        return this;
    }

    public Long getReceiverDeviceId(boolean required) {
        this.checkHeader();
        return this.header.getReceiverDeviceId(required);
    }

    public Message<TBody> setReceiverDeviceId(Long receiverDeviceId) {
        this.checkHeader();
        this.header.setReceiverDeviceId(receiverDeviceId);
        return this;
    }

    public Long getReceiverUserId(boolean required) {
        this.checkHeader();
        return this.header.getReceiverUserId(required);
    }

    public Message<TBody> setReceiverUserId(Long receiverUserId) {
        this.checkHeader();
        this.header.setReceiverUserId(receiverUserId);
        return this;
    }

    public Long getReceiverGroupId(boolean required) {
        this.checkHeader();
        return this.header.getReceiverGroupId(required);
    }

    public Message<TBody> setReceiverGroupId(Long receiverGroupId) {
        this.checkHeader();
        this.header.setReceiverGroupId(receiverGroupId);
        return this;
    }

    public Long getReceiverRoomId(boolean required) {
        this.checkHeader();
        return this.header.getReceiverRoomId(required);
    }

    public Message<TBody> setReceiverRoomId(Long receiverRoomId) {
        this.checkHeader();
        this.header.setReceiverRoomId(receiverRoomId);
        return this;
    }

    public Integer getReceiverConnectorId(boolean required) {
        this.checkHeader();
        return this.header.getReceiverConnectorId(required);
    }

    public Message<TBody> setReceiverConnectorId(Integer receiverConnectorId) {
        this.checkHeader();
        this.header.setReceiverConnectorId(receiverConnectorId);
        return this;
    }

    public static <TBody> Message<TBody> ofRouter() {
        return Message.ofDirection(RouteDirection.ROUTER);
    }

    public static <TBody> Message<TBody> ofConnector() {
        return Message.ofDirection(RouteDirection.CONNECTOR);
    }

    public static <TBody> Message<TBody> ofCommander() {
        return Message.ofDirection(RouteDirection.COMMANDER);
    }

    public static <TBody> Message<TBody> ofDirection(RouteDirection routeDirection) {
        return new Message<TBody>().setHeader(new MessageHeader().setDirection(routeDirection));
    }

    public static <TBody> Message<TBody> ofCommandType(String commandType) {
        return new Message<TBody>().setHeader(new MessageHeader().setCommandType(commandType));
    }

    public static Message<Void> error(String errorCode, String errorMsg) {
        return Message.error(errorCode, errorMsg, null);
    }

    public static Message<Void> error(String errorCode, String errorMsg, Message sourceMessage) {
        Message<Void> errorMessage = Message.ofCommandType("error");
        errorMessage.setErrorCode(errorCode);
        if (Objects.nonNull(errorMsg)) {
            errorMessage.setErrorMsg(errorMsg);
        }
        if (Objects.nonNull(sourceMessage)) {
            Integer sourceSenderConnectorId;
            String sourceSenderChannelId;
            MessageHeader sourceMsgHeader = sourceMessage.getHeader();
            String sourceClientMsgId = sourceMsgHeader.getClientMessageId(false);
            if (!Strings.isNullOrEmpty((String)sourceClientMsgId)) {
                errorMessage.setClientMessageId(sourceClientMsgId);
            }
            if (!Strings.isNullOrEmpty((String)(sourceSenderChannelId = sourceMsgHeader.getSenderChannelId(false)))) {
                errorMessage.setReceiverChannelId(sourceSenderChannelId);
            }
            if (Objects.nonNull(sourceSenderConnectorId = sourceMsgHeader.getSenderConnectorId(false))) {
                errorMessage.setReceiverConnectorId(sourceSenderConnectorId);
            }
        }
        return errorMessage;
    }

    public Message<TBody> clone() {
        Message msgClone = (Message)super.clone();
        msgClone.header = (MessageHeader)this.header.clone();
        return msgClone;
    }

    public String toString() {
        return "Message{header=" + this.header + ", body=" + this.body + '}';
    }

    public MessageHeader getHeader() {
        return this.header;
    }

    public TBody getBody() {
        return this.body;
    }
}

