/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.message;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.util.HashMap;
import java.util.Objects;
import me.ahoo.pigeon.core.message.RouteDirection;
import me.ahoo.pigeon.core.message.SendMode;

public class MessageHeader
extends HashMap<String, Object> {
    public <TValue> TValue getGenericValue(String key, Class<TValue> valClass, boolean required, Function<Object, TValue> converter) {
        Object valObj = this.get(key);
        if (Objects.isNull(valObj)) {
            if (required) {
                throw new NullPointerException(String.format("Header:[%s] can not be null!", key));
            }
            return null;
        }
        if (valClass.isInstance(valObj)) {
            return (TValue)valObj;
        }
        Object convertedVal = converter.apply(valObj);
        this.computeIfPresent(key, (k, v) -> convertedVal);
        return (TValue)convertedVal;
    }

    public String getStringValue(String key, boolean required) {
        return this.getGenericValue(key, String.class, required, obj -> obj.toString());
    }

    public Integer getIntegerValue(String key, boolean required) {
        return this.getGenericValue(key, Integer.class, required, obj -> Integer.valueOf(obj.toString()));
    }

    public Long getLongValue(String key, boolean required) {
        return this.getGenericValue(key, Long.class, required, obj -> Longs.tryParse((String)obj.toString()));
    }

    public RouteDirection getDirection(boolean required) {
        Integer directionValue = this.getIntegerValue("d", required);
        if (Objects.isNull(directionValue)) {
            return null;
        }
        return RouteDirection.valueOf(directionValue);
    }

    public MessageHeader setDirection(RouteDirection direction) {
        Preconditions.checkNotNull((Object)((Object)direction), (Object)"RouteDirection can not be null!");
        this.put("d", direction.getValue());
        return this;
    }

    public String getCommandType(boolean required) {
        return this.getStringValue("t", required);
    }

    public MessageHeader setCommandType(String commandType) {
        Preconditions.checkNotNull((Object)commandType, (Object)"commandType can not be null!");
        this.put("t", commandType);
        return this;
    }

    public Long getId(boolean required) {
        return this.getLongValue("id", required);
    }

    public MessageHeader setId(Long id) {
        Preconditions.checkNotNull((Object)id, (Object)"id can not be null!");
        this.put("id", id);
        return this;
    }

    public MessageHeader setSendMode(SendMode sendMode) {
        this.put("m", sendMode.getValue());
        return this;
    }

    public MessageHeader setSendModeIfAbsent(SendMode sendMode) {
        if (this.containsKey("m")) {
            return this;
        }
        this.put("m", sendMode.getValue());
        return this;
    }

    public SendMode getSendMode(boolean required) {
        Integer sendModeValue = this.getIntegerValue("m", required);
        return SendMode.valueOf(sendModeValue);
    }

    public String getClientMessageId(boolean required) {
        return this.getStringValue("c_m_id", required);
    }

    public MessageHeader setClientMessageId(String clientMessageId) {
        Preconditions.checkNotNull((Object)clientMessageId, (Object)"clientMessageId can not be null!");
        this.put("c_m_id", clientMessageId);
        return this;
    }

    public Long getServerMessageId(boolean required) {
        return this.getLongValue("s_m_id", required);
    }

    public MessageHeader setServerMessageId(Long serverMessageId) {
        Preconditions.checkNotNull((Object)serverMessageId, (Object)"serverMessageId can not be null!");
        this.put("s_m_id", serverMessageId);
        return this;
    }

    public Integer getSenderConnectorId(boolean required) {
        return this.getIntegerValue("s_c_id", required);
    }

    public MessageHeader setSenderConnectorId(Integer senderConnectorId) {
        Preconditions.checkNotNull((Object)senderConnectorId, (Object)"senderConnectorId can not be null!");
        this.put("s_c_id", senderConnectorId);
        return this;
    }

    public Long getSenderUserId(boolean required) {
        return this.getLongValue("s_u_id", required);
    }

    public MessageHeader setSenderUserId(Long senderUserId) {
        Preconditions.checkNotNull((Object)senderUserId, (Object)"senderUserId can not be null!");
        this.put("s_u_id", senderUserId);
        return this;
    }

    public String getSenderChannelId(boolean required) {
        return this.getStringValue("s_h_id", required);
    }

    public MessageHeader setSenderChannelId(String senderChannelId) {
        Preconditions.checkNotNull((Object)senderChannelId, (Object)"senderChannelId can not be null!");
        this.put("s_h_id", senderChannelId);
        return this;
    }

    public Long getSenderDeviceId(boolean required) {
        return this.getLongValue("s_d_id", required);
    }

    public MessageHeader setSenderDeviceId(Long senderDeviceId) {
        Preconditions.checkNotNull((Object)senderDeviceId, (Object)"senderDeviceId can not be null!");
        this.put("s_d_id", senderDeviceId);
        return this;
    }

    public Long getCreateTime(boolean required) {
        return this.getLongValue("c_t", required);
    }

    public MessageHeader setCreateTime(Long createTime) {
        Preconditions.checkNotNull((Object)createTime, (Object)"createTime can not be null!");
        this.put("c_t", createTime);
        return this;
    }

    public MessageHeader ofNow() {
        this.setCreateTime(System.currentTimeMillis());
        return this;
    }

    public String getReceiverChannelId(boolean required) {
        return this.getStringValue("r_h_id", required);
    }

    public MessageHeader setReceiverChannelId(String receiverChannelId) {
        Preconditions.checkNotNull((Object)receiverChannelId, (Object)"receiverChannelId can not be null!");
        this.setSendModeIfAbsent(SendMode.TO_CHANNEL);
        this.put("r_h_id", receiverChannelId);
        return this;
    }

    public Long getReceiverDeviceId(boolean required) {
        return this.getLongValue("r_d_id", required);
    }

    public MessageHeader setReceiverDeviceId(Long receiverDeviceId) {
        Preconditions.checkNotNull((Object)receiverDeviceId, (Object)"receiverDeviceId can not be null!");
        this.setSendModeIfAbsent(SendMode.TO_DEVICE);
        this.put("r_d_id", receiverDeviceId);
        return this;
    }

    public Long getReceiverUserId(boolean required) {
        return this.getLongValue("r_u_id", required);
    }

    public MessageHeader setReceiverUserId(Long receiverUserId) {
        Preconditions.checkNotNull((Object)receiverUserId, (Object)"receiverUserId can not be null!");
        this.setSendModeIfAbsent(SendMode.TO_USER);
        this.put("r_u_id", receiverUserId);
        return this;
    }

    public Long getReceiverGroupId(boolean required) {
        return this.getLongValue("r_g_id", required);
    }

    public MessageHeader setReceiverGroupId(Long receiverGroupId) {
        Preconditions.checkNotNull((Object)receiverGroupId, (Object)"receiverGroupId can not be null!");
        this.setSendModeIfAbsent(SendMode.TO_GROUP);
        this.put("r_g_id", receiverGroupId);
        return this;
    }

    public Long getReceiverRoomId(boolean required) {
        return this.getLongValue("r_r_id", required);
    }

    public MessageHeader setReceiverRoomId(Long receiverRoomId) {
        Preconditions.checkNotNull((Object)receiverRoomId, (Object)"receiverRoomId can not be null!");
        this.setSendModeIfAbsent(SendMode.TO_ROOM);
        this.put("r_r_id", receiverRoomId);
        return this;
    }

    public Integer getReceiverConnectorId(boolean required) {
        return this.getIntegerValue("r_c_id", required);
    }

    public MessageHeader setReceiverConnectorId(Integer receiverConnectorId) {
        Preconditions.checkNotNull((Object)receiverConnectorId, (Object)"receiverConnectorId can not be null!");
        this.put("r_c_id", receiverConnectorId);
        return this;
    }

    public String getFilterExpression(boolean required) {
        return this.getStringValue("f", required);
    }

    public MessageHeader setFilterExpression(String filterExpression) {
        Preconditions.checkNotNull((Object)filterExpression, (Object)"filterExpression can not be null!");
        this.put("f", filterExpression);
        return this;
    }

    public String getErrorCode(boolean required) {
        return this.getStringValue("error_code", required);
    }

    public MessageHeader setErrorCode(String errorCode) {
        Preconditions.checkNotNull((Object)errorCode, (Object)"errorCode can not be null!");
        this.put("error_code", errorCode);
        return this;
    }

    public String getErrorMsg(boolean required) {
        return this.getStringValue("error_msg", required);
    }

    public MessageHeader setErrorMsg(String errorMsg) {
        Preconditions.checkNotNull((Object)errorMsg, (Object)"errorMsg can not be null!");
        this.put("error_msg", errorMsg);
        return this;
    }

    public String getClientIp(boolean required) {
        return this.getStringValue("c_ip", required);
    }

    public MessageHeader setClientIp(String clientIp) {
        Preconditions.checkNotNull((Object)clientIp, (Object)"clientIp can not be null!");
        this.put("c_ip", clientIp);
        return this;
    }

    public Integer getRetryTimes(boolean required) {
        return this.getIntegerValue("retry_times", required);
    }

    public MessageHeader setRetryTimes(Integer retryTimes) {
        Preconditions.checkNotNull((Object)retryTimes, (Object)"retryTimes can not be null!");
        this.put("retry_times", retryTimes);
        return this;
    }

    public boolean isRetry() {
        Integer retryTimes = this.getRetryTimes(false);
        return Objects.nonNull(retryTimes) && retryTimes > 0;
    }

    public String getApp(boolean required) {
        return this.getStringValue("app", required);
    }

    public MessageHeader setApp(String app) {
        Preconditions.checkNotNull((Object)app, (Object)"app can not be null!");
        this.put("app", app);
        return this;
    }

    public static interface Headers {
        public static final String APP = "app";
        public static final String DIRECTION = "d";
        public static final String COMMAND_TYPE = "t";
        public static final String ID = "id";
        public static final String CREATE_TIME = "c_t";
        public static final String AUTH = "auth";
        public static final String FILTER_EXPRESSION = "f";
        public static final String SEND_MODE = "m";
        public static final String CLIENT_MESSAGE_ID = "c_m_id";
        public static final String SERVER_MESSAGE_ID = "s_m_id";
        public static final String CLIENT_IP = "c_ip";
        public static final String RETRY_TIMES = "retry_times";
        public static final String SENDER_CONNECTOR_ID = "s_c_id";
        public static final String SENDER_USER_ID = "s_u_id";
        public static final String SENDER_CHANNEL_ID = "s_h_id";
        public static final String SENDER_DEVICE_ID = "s_d_id";
        public static final String RECEIVER_CONNECTOR_ID = "r_c_id";
        public static final String RECEIVER_USER_ID = "r_u_id";
        public static final String RECEIVER_CHANNEL_ID = "r_h_id";
        public static final String RECEIVER_DEVICE_ID = "r_d_id";
        public static final String RECEIVER_GROUP_ID = "r_g_id";
        public static final String RECEIVER_ROOM_ID = "r_r_id";
        public static final String ERROR_CODE = "error_code";
        public static final String ERROR_MSG = "error_msg";
    }
}

