/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.authorization;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import me.ahoo.pigeon.core.exception.PigeonException;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.AuthorizationSupport;
import me.ahoo.pigeon.core.security.authorization.AuthorizeResult;
import me.ahoo.pigeon.core.security.authorization.User;
import me.ahoo.pigeon.core.security.authorization.UserAuthorization;

public class CompositeAuthorization
implements UserAuthorization {
    private final List<AuthorizationSupport> delegates;

    public CompositeAuthorization(List<AuthorizationSupport> delegates) {
        Preconditions.checkState((!delegates.isEmpty() ? 1 : 0) != 0, (Object)"AuthorizationSupports can not be empty.");
        this.delegates = delegates;
    }

    @Override
    public AuthorizeResult<User> authorize(SecurityContext securityContext, Message authRequest) {
        Optional<AuthorizationSupport> delegate = this.delegates.stream().filter(d -> d.support(authRequest)).findFirst();
        if (!delegate.isPresent()) {
            throw new PigeonException("authorize-0000", String.format("CompositeAuthorization can not find any Authorization for Message.Id:[%s]", authRequest.getHeader().getId(false)));
        }
        return delegate.get().authorize(securityContext, authRequest);
    }
}

