/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.authorization;

public class Device {
    public static final String AGENT = "Device-Agent";
    private final Long id;
    private Long ownerId;
    private final String name;
    private final String agent;

    public String toString() {
        return "Device{id=" + this.id + ", ownerId=" + this.ownerId + ", name='" + this.name + '\'' + ", agent='" + this.agent + '\'' + '}';
    }

    Device(Long id, Long ownerId, String name, String agent) {
        this.id = id;
        this.ownerId = ownerId;
        this.name = name;
        this.agent = agent;
    }

    public static DeviceBuilder builder() {
        return new DeviceBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public static class DeviceBuilder {
        private Long id;
        private Long ownerId;
        private String name;
        private String agent;

        DeviceBuilder() {
        }

        public DeviceBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public DeviceBuilder ownerId(Long ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public DeviceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DeviceBuilder agent(String agent) {
            this.agent = agent;
            return this;
        }

        public Device build() {
            return new Device(this.id, this.ownerId, this.name, this.agent);
        }

        public String toString() {
            return "Device.DeviceBuilder(id=" + this.id + ", ownerId=" + this.ownerId + ", name=" + this.name + ", agent=" + this.agent + ")";
        }
    }
}

