/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.authorization;

import com.google.common.collect.ImmutableMap;

public class User {
    private final Long id;
    private final String username;
    private final String nickname;
    private final String avatar;
    private final String role;
    private ImmutableMap<String, Object> attr;

    public String toString() {
        return "User{id=" + this.id + ", username='" + this.username + '\'' + ", nickname='" + this.nickname + '\'' + ", avatar='" + this.avatar + '\'' + ", role='" + this.role + '\'' + '}';
    }

    User(Long id, String username, String nickname, String avatar, String role, ImmutableMap<String, Object> attr) {
        this.id = id;
        this.username = username;
        this.nickname = nickname;
        this.avatar = avatar;
        this.role = role;
        this.attr = attr;
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getRole() {
        return this.role;
    }

    public ImmutableMap<String, Object> getAttr() {
        return this.attr;
    }

    public static class UserBuilder {
        private Long id;
        private String username;
        private String nickname;
        private String avatar;
        private String role;
        private ImmutableMap<String, Object> attr;

        UserBuilder() {
        }

        public UserBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public UserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public UserBuilder nickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public UserBuilder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public UserBuilder role(String role) {
            this.role = role;
            return this;
        }

        public UserBuilder attr(ImmutableMap<String, Object> attr) {
            this.attr = attr;
            return this;
        }

        public User build() {
            return new User(this.id, this.username, this.nickname, this.avatar, this.role, this.attr);
        }

        public String toString() {
            return "User.UserBuilder(id=" + this.id + ", username=" + this.username + ", nickname=" + this.nickname + ", avatar=" + this.avatar + ", role=" + this.role + ", attr=" + this.attr + ")";
        }
    }
}

