/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.authorization.jwt;

import java.util.Objects;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.AuthorizeResult;
import me.ahoo.pigeon.core.security.authorization.Device;
import me.ahoo.pigeon.core.security.authorization.DeviceAuthorization;
import me.ahoo.pigeon.core.security.authorization.jwt.JwtProvider;
import me.ahoo.pigeon.core.security.authorization.jwt.config.DeviceConfig;
import me.ahoo.pigeon.core.security.device.DeviceRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtDeviceAuthorization
implements DeviceAuthorization {
    private static final Logger log = LoggerFactory.getLogger(JwtDeviceAuthorization.class);
    private final JwtProvider jwtProvider;
    private final DeviceRegistrar deviceRegistrar;

    public JwtDeviceAuthorization(DeviceRegistrar deviceRegistrar, DeviceConfig deviceConfig) {
        this.deviceRegistrar = deviceRegistrar;
        this.jwtProvider = new JwtProvider(deviceConfig.getAlgName(), deviceConfig.getSecretKey(), deviceConfig.getValidityTime());
    }

    @Override
    public AuthorizeResult<Device> authorize(SecurityContext securityContext, Message authMessage) {
        Device device;
        block4: {
            Object jwtToken = authMessage.getHeader().get("auth");
            device = null;
            if (Objects.nonNull(jwtToken)) {
                try {
                    device = this.jwtProvider.parseDevice(jwtToken.toString());
                }
                catch (Throwable throwable) {
                    if (!log.isInfoEnabled()) break block4;
                    log.info("parseDevice failure:{}", (Object)throwable.getMessage());
                }
            }
        }
        if (Objects.isNull(device)) {
            device = this.deviceRegistrar.register(authMessage);
        }
        String deviceToken = this.jwtProvider.parseDeviceToken(device);
        return AuthorizeResult.builder().accessToken(deviceToken).body(device).build();
    }
}

