/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.authorization.jwt;

import com.google.common.primitives.Longs;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.time.Duration;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import me.ahoo.pigeon.core.security.authorization.AuthorizationFailedException;
import me.ahoo.pigeon.core.security.authorization.Device;
import me.ahoo.pigeon.core.security.authorization.Room;
import me.ahoo.pigeon.core.security.authorization.jwt.JwtConstants;

public class JwtProvider {
    private final SecretKey secretKey;
    private final Duration validityTime;
    private static final String DEVICE_NAME = "name";
    private static final String ROOM_NAME = "name";
    private static final String DEVICE_AGENT = "agent";

    public JwtProvider(String algName, String secretKey, Duration validityTime) {
        if (Objects.isNull(validityTime)) {
            validityTime = Duration.ofHours(2L);
        }
        this.validityTime = validityTime;
        byte[] secretKeyBytes = Base64.getDecoder().decode(secretKey);
        this.secretKey = new SecretKeySpec(secretKeyBytes, algName);
    }

    public Claims parseClaims(String token) {
        try {
            String jwtToken = token.substring(JwtConstants.TOKEN_PREFIX_LENGTH);
            return (Claims)Jwts.parserBuilder().setSigningKey((Key)this.secretKey).build().parseClaimsJws(jwtToken).getBody();
        }
        catch (Throwable e) {
            throw new AuthorizationFailedException("Auth-Jwt-0001", e.getMessage(), e);
        }
    }

    public Device parseDevice(String token) {
        Object deviceAgent;
        Claims claims = this.parseClaims(token);
        Device.DeviceBuilder deviceBuilder = Device.builder();
        Long deviceId = Longs.tryParse((String)claims.getSubject());
        deviceBuilder.id(deviceId);
        Object name = claims.get((Object)"name");
        if (Objects.nonNull(name)) {
            deviceBuilder.name(name.toString());
        }
        if (Objects.nonNull(deviceAgent = claims.get((Object)DEVICE_AGENT))) {
            deviceBuilder.agent(deviceAgent.toString());
        }
        return deviceBuilder.build();
    }

    public Room parseRoom(String token) {
        Claims claims = this.parseClaims(token);
        Room.RoomBuilder roomBuilder = Room.builder();
        Long roomId = Longs.tryParse((String)claims.getSubject());
        roomBuilder.id(roomId);
        Object name = claims.get((Object)"name");
        if (Objects.nonNull(name)) {
            roomBuilder.name(name.toString());
        }
        return roomBuilder.build();
    }

    public String parseDeviceToken(Device device) {
        try {
            Date now = new Date();
            Date validity = new Date(now.getTime() + this.validityTime.toMillis());
            String jwtId = UUID.randomUUID().toString();
            String jwtToken = Jwts.builder().setId(jwtId).setSubject(device.getId().toString()).claim("name", (Object)device.getName()).claim(DEVICE_AGENT, (Object)device.getAgent()).setIssuedAt(now).setExpiration(validity).signWith((Key)this.secretKey).compact();
            return "Bearer " + jwtToken;
        }
        catch (ExpiredJwtException e) {
            throw new AuthorizationFailedException("Auth-Jwt-0002", e.getMessage());
        }
        catch (Throwable e) {
            throw new AuthorizationFailedException("Auth-Jwt-0002", e.getMessage());
        }
    }
}

