/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.authorization.jwt;

import java.util.Objects;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.AuthorizeResult;
import me.ahoo.pigeon.core.security.authorization.Room;
import me.ahoo.pigeon.core.security.authorization.RoomAuthorization;
import me.ahoo.pigeon.core.security.authorization.jwt.JwtProvider;
import me.ahoo.pigeon.core.security.authorization.jwt.config.RoomConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtRoomAuthorization
implements RoomAuthorization {
    private static final Logger log = LoggerFactory.getLogger(JwtRoomAuthorization.class);
    private final JwtProvider jwtProvider;

    public JwtRoomAuthorization(RoomConfig roomConfig) {
        this.jwtProvider = new JwtProvider(roomConfig.getAlgName(), roomConfig.getSecretKey(), roomConfig.getValidityTime());
    }

    @Override
    public AuthorizeResult<Room> authorize(SecurityContext securityContext, Message authMessage) {
        Room room;
        Object jwtToken;
        block3: {
            jwtToken = authMessage.getHeader().get("auth");
            room = null;
            if (Objects.nonNull(jwtToken)) {
                try {
                    room = this.jwtProvider.parseRoom(jwtToken.toString());
                }
                catch (Throwable throwable) {
                    if (!log.isInfoEnabled()) break block3;
                    log.info("parseRoom failure:{}", (Object)throwable.getMessage());
                }
            }
        }
        return AuthorizeResult.builder().accessToken(jwtToken.toString()).body(room).build();
    }
}

