/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.authorization.jwt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import io.jsonwebtoken.Claims;
import java.util.Map;
import java.util.Objects;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.AuthorizationSupport;
import me.ahoo.pigeon.core.security.authorization.AuthorizeResult;
import me.ahoo.pigeon.core.security.authorization.User;
import me.ahoo.pigeon.core.security.authorization.UserAuthorization;
import me.ahoo.pigeon.core.security.authorization.jwt.JwtProvider;
import me.ahoo.pigeon.core.security.authorization.jwt.config.UserConfig;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class JwtUserAuthorization
implements UserAuthorization,
AuthorizationSupport {
    private final JwtProvider jwtProvider;
    private String claimId = "id";
    private String claimUsername = "username";
    private String claimNickname = "nickname";
    private String claimAvatar = "avatar";
    private String claimRole = "role";
    private static final String CLAIM_MAP_ID = "id";
    private static final String CLAIM_MAP_USERNAME = "username";
    private static final String CLAIM_MAP_NICKNAME = "nickname";
    private static final String CLAIM_MAP_ROLE = "role";
    private static final String CLAIM_MAP_AVATAR = "avatar";

    public JwtUserAuthorization(UserConfig userConfig) {
        this.jwtProvider = new JwtProvider(userConfig.getAlgName(), userConfig.getSecretKey(), userConfig.getValidityTime());
        Map<String, String> claimMap = userConfig.getClaimMap();
        if (Objects.nonNull(claimMap)) {
            this.claimId = claimMap.getOrDefault(CLAIM_MAP_ID, this.claimId);
            this.claimUsername = claimMap.getOrDefault(CLAIM_MAP_USERNAME, this.claimUsername);
            this.claimNickname = claimMap.getOrDefault(CLAIM_MAP_NICKNAME, this.claimNickname);
            this.claimAvatar = claimMap.getOrDefault(CLAIM_MAP_AVATAR, this.claimAvatar);
            this.claimRole = claimMap.getOrDefault(CLAIM_MAP_ROLE, this.claimRole);
        }
    }

    @Override
    public AuthorizeResult<User> authorize(SecurityContext securityContext, Message authMessage) {
        Object role;
        Object avatar;
        Object nickname;
        Object jwtToken = authMessage.getHeader().get("auth");
        Preconditions.checkNotNull(jwtToken, (String)"Header.%s can not be null.", (Object)"auth");
        Claims claims = this.jwtProvider.parseClaims(jwtToken.toString());
        User.UserBuilder userBuilder = User.builder();
        Object userId = claims.get((Object)this.claimId);
        Preconditions.checkNotNull((Object)userId, (Object)"id can not be null.");
        userBuilder.id(Longs.tryParse((String)userId.toString()));
        Object username = claims.get((Object)this.claimUsername);
        if (Objects.nonNull(username)) {
            userBuilder.username(username.toString());
        }
        if (Objects.nonNull(nickname = claims.get((Object)this.claimNickname))) {
            userBuilder.nickname(nickname.toString());
        }
        if (Objects.nonNull(avatar = claims.get((Object)this.claimAvatar))) {
            userBuilder.avatar(avatar.toString());
        }
        if (Objects.nonNull(role = claims.get((Object)this.claimRole))) {
            userBuilder.role(role.toString());
        }
        userBuilder.attr((ImmutableMap<String, Object>)ImmutableMap.copyOf((Map)claims));
        return AuthorizeResult.builder().accessToken(jwtToken.toString()).body(userBuilder.build()).build();
    }

    @Override
    public boolean support(Message authMessage) {
        Object authObj = authMessage.getHeader().get("auth");
        if (Objects.isNull(authObj)) {
            return false;
        }
        String authStr = authObj.toString();
        return authStr.startsWith("Bearer ");
    }
}

