/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.command;

import java.util.Optional;
import java.util.Set;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.command.CommandAuthorization;

public class WhitelistCommandAuthorization
implements CommandAuthorization {
    private static final String ASTERISK = "*";
    private final boolean allowAll;
    private final Set<String> cmdWhitelist;

    public WhitelistCommandAuthorization(Set<String> cmdWhitelist) {
        Optional firstCmdOp = cmdWhitelist.stream().findFirst();
        this.allowAll = firstCmdOp.isPresent() ? ASTERISK.equals(firstCmdOp.get()) : false;
        this.cmdWhitelist = cmdWhitelist;
    }

    @Override
    public boolean authorize(SecurityContext securityContext, Message message) {
        if (this.allowAll) {
            return true;
        }
        return this.cmdWhitelist.contains(message.getCommandType(true));
    }
}

