/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.command.mather;

import me.ahoo.pigeon.core.security.command.mather.CommandMatcher;
import me.ahoo.pigeon.core.security.command.mather.ContainsCommandMatcher;
import me.ahoo.pigeon.core.security.command.mather.EqualCommandMatcher;
import me.ahoo.pigeon.core.security.command.mather.PrefixCommandMatcher;
import me.ahoo.pigeon.core.security.command.mather.SuffixCommandMatcher;
import me.ahoo.pigeon.core.security.command.mather.TrueCommandMatcher;

public final class CommandMatcherFactory {
    public static final String WILDCARD = "*";

    public static CommandMatcher of(String commandMatch) {
        if (WILDCARD.equals(commandMatch)) {
            return TrueCommandMatcher.INSTANCE;
        }
        if (commandMatch.startsWith(WILDCARD) && commandMatch.endsWith(WILDCARD)) {
            String substring = commandMatch.substring(1, commandMatch.length() - 1);
            return new ContainsCommandMatcher(substring);
        }
        if (commandMatch.startsWith(WILDCARD)) {
            String suffix = commandMatch.substring(1);
            return new SuffixCommandMatcher(suffix);
        }
        if (commandMatch.endsWith(WILDCARD)) {
            String prefix = commandMatch.substring(0, commandMatch.length() - 1);
            return new PrefixCommandMatcher(prefix);
        }
        return new EqualCommandMatcher(commandMatch);
    }
}

