/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.command.privilege;

import java.util.List;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.command.mather.CommandMatcher;
import me.ahoo.pigeon.core.security.command.mather.TrueCommandMatcher;
import me.ahoo.pigeon.core.security.command.privilege.PrivilegeChecker;

public class CommandPrivilegeChecker
implements PrivilegeChecker {
    private final boolean allowAll;
    private final List<CommandMatcher> commandMatchers;

    public CommandPrivilegeChecker(List<CommandMatcher> commandMatchers) {
        this.commandMatchers = commandMatchers;
        this.allowAll = commandMatchers.stream().anyMatch(commandMatcher -> commandMatcher instanceof TrueCommandMatcher);
    }

    @Override
    public boolean check(SecurityContext securityContext, String commandType) {
        if (this.allowAll) {
            return true;
        }
        return this.commandMatchers.stream().anyMatch(commandMatch -> commandMatch.isMatch(commandType));
    }
}

