/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.command.privilege;

import java.util.Map;
import java.util.Objects;
import me.ahoo.pigeon.core.security.SecurityContext;
import me.ahoo.pigeon.core.security.authorization.User;
import me.ahoo.pigeon.core.security.command.privilege.CommandPrivilegeChecker;
import me.ahoo.pigeon.core.security.command.privilege.PrivilegeChecker;

public class PrivilegeGroup
implements PrivilegeChecker {
    private CommandPrivilegeChecker unAuthorization;
    private CommandPrivilegeChecker authorization;
    private Map<Long, CommandPrivilegeChecker> users;
    private Map<String, CommandPrivilegeChecker> roles;

    public CommandPrivilegeChecker getUnAuthorization() {
        return this.unAuthorization;
    }

    public void setUnAuthorization(CommandPrivilegeChecker all) {
        this.unAuthorization = all;
    }

    public CommandPrivilegeChecker getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(CommandPrivilegeChecker authorization) {
        this.authorization = authorization;
    }

    public Map<Long, CommandPrivilegeChecker> getUsers() {
        return this.users;
    }

    public void setUsers(Map<Long, CommandPrivilegeChecker> users) {
        this.users = users;
    }

    public Map<String, CommandPrivilegeChecker> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, CommandPrivilegeChecker> roles) {
        this.roles = roles;
    }

    @Override
    public boolean check(SecurityContext securityContext, String commandType) {
        if (Objects.nonNull(this.unAuthorization) && this.unAuthorization.check(securityContext, commandType)) {
            return true;
        }
        User user = securityContext.getUser();
        if (Objects.isNull(user)) {
            return false;
        }
        if (Objects.nonNull(this.authorization) && this.authorization.check(securityContext, commandType)) {
            return true;
        }
        CommandPrivilegeChecker userPrivilege = this.users.get(user.getId());
        if (Objects.nonNull(userPrivilege) && userPrivilege.check(securityContext, commandType)) {
            return true;
        }
        CommandPrivilegeChecker rolePrivilege = this.roles.get(user.getRole());
        return Objects.nonNull(rolePrivilege) && rolePrivilege.check(securityContext, commandType);
    }
}

