/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.security.command.privilege.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.ahoo.pigeon.core.security.command.mather.CommandMatcher;
import me.ahoo.pigeon.core.security.command.mather.CommandMatcherFactory;
import me.ahoo.pigeon.core.security.command.privilege.CommandPrivilegeChecker;
import me.ahoo.pigeon.core.security.command.privilege.PrivilegeGroup;

public class PrivilegeConfig {
    private List<String> unAuth;
    private List<String> auth;
    private Map<String, List<String>> role;
    private Map<Long, List<String>> user;

    public List<String> getUnAuth() {
        return this.unAuth;
    }

    public void setUnAuth(List<String> unAuth) {
        this.unAuth = unAuth;
    }

    public List<String> getAuth() {
        return this.auth;
    }

    public void setAuth(List<String> auth) {
        this.auth = auth;
    }

    public Map<String, List<String>> getRole() {
        return this.role;
    }

    public void setRole(Map<String, List<String>> role) {
        this.role = role;
    }

    public Map<Long, List<String>> getUser() {
        return this.user;
    }

    public void setUser(Map<Long, List<String>> user) {
        this.user = user;
    }

    public PrivilegeGroup asPrivilegeGroup() {
        PrivilegeGroup privilegeGroup = new PrivilegeGroup();
        if (Objects.nonNull(this.unAuth) && !this.unAuth.isEmpty()) {
            CommandPrivilegeChecker unAuthChecker = this.asCommandPrivilegeChecker(this.unAuth);
            privilegeGroup.setUnAuthorization(unAuthChecker);
        }
        if (Objects.nonNull(this.auth) && !this.auth.isEmpty()) {
            CommandPrivilegeChecker authChecker = this.asCommandPrivilegeChecker(this.auth);
            privilegeGroup.setAuthorization(authChecker);
        }
        if (Objects.nonNull(this.role) && !this.role.isEmpty()) {
            HashMap<String, CommandPrivilegeChecker> roles = new HashMap<String, CommandPrivilegeChecker>(this.role.size());
            this.role.forEach((roleName, commands) -> {
                if (commands.isEmpty()) {
                    return;
                }
                roles.put((String)roleName, this.asCommandPrivilegeChecker((List<String>)commands));
            });
            privilegeGroup.setRoles(roles);
        }
        if (Objects.nonNull(this.user) && !this.user.isEmpty()) {
            HashMap<Long, CommandPrivilegeChecker> users = new HashMap<Long, CommandPrivilegeChecker>(this.user.size());
            this.user.forEach((userId, commands) -> {
                if (commands.isEmpty()) {
                    return;
                }
                users.put((Long)userId, this.asCommandPrivilegeChecker((List<String>)commands));
            });
            privilegeGroup.setUsers(users);
        }
        return privilegeGroup;
    }

    private CommandPrivilegeChecker asCommandPrivilegeChecker(List<String> commands) {
        List<CommandMatcher> commandMatchers = commands.stream().map(commandMatch -> CommandMatcherFactory.of(commandMatch)).collect(Collectors.toList());
        return new CommandPrivilegeChecker(commandMatchers);
    }
}

