/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import me.ahoo.pigeon.core.exception.PigeonException;
import me.ahoo.pigeon.core.message.Message;
import me.ahoo.pigeon.core.message.RouteDirection;

public final class Messages {
    public static Message clientResponseOf(Message reqMsg) {
        Message respMsg = Message.ofDirection(RouteDirection.CLIENT);
        String clientMsgId = reqMsg.getClientMessageId(true);
        return respMsg.setClientMessageId(clientMsgId);
    }

    public static Message clientErrorResponseOf(Message reqMsg, PigeonException pigeonException) {
        return Messages.clientResponseOf(reqMsg).setErrorCode(pigeonException.getCode()).setErrorMsg(pigeonException.getMessage());
    }

    public static Message clientErrorResponseOf(Message reqMsg, Throwable throwable) {
        return Messages.clientResponseOf(reqMsg).setErrorCode("0001").setErrorMsg(throwable.getMessage());
    }

    public static Class<?> getBodyClass(Method subscribeMethod) {
        Type parameterType = subscribeMethod.getGenericParameterTypes()[0];
        return Messages.getBodyClass(parameterType);
    }

    public static Class<?> getBodyClass(Type parameterType) {
        if (parameterType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)parameterType;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        if (!(parameterType instanceof Class) || Message.class.equals((Object)parameterType)) {
            return String.class;
        }
        Class msgClass = (Class)parameterType;
        return Messages.getBodyClass(msgClass.getGenericSuperclass());
    }
}

