/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import me.ahoo.pigeon.core.util.Clazzs;

public abstract class Resources {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";

    public static InputStream getResource(@Nonnull String resourceLocation) {
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            return Resources.getClassPathResource(path);
        }
        if (resourceLocation.startsWith(FILE_URL_PREFIX)) {
            String path = resourceLocation.substring(FILE_URL_PREFIX.length());
            return Resources.getFileResource(path);
        }
        return new FileInputStream(resourceLocation);
    }

    public static InputStream getFileResource(String path) {
        File file = new File(path);
        return new FileInputStream(file);
    }

    public static InputStream getClassPathResource(String path) {
        URL url;
        ClassLoader cl = Clazzs.getDefaultClassLoader();
        URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
        if (url == null) {
            String description = "class path resource [" + path + "]";
            throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
        }
        return url.openStream();
    }
}

