package me.ahoo.pigeon.starter.bus;

import me.ahoo.pigeon.core.bus.Dispatcher;
import me.ahoo.pigeon.core.bus.MessageBus;
import me.ahoo.pigeon.core.bus.MessageTopicParser;
import me.ahoo.pigeon.core.bus.TopicParser;
import me.ahoo.pigeon.core.bus.impl.DefaultTopicParser;
import me.ahoo.pigeon.core.bus.impl.MemoryMessageBus;
import me.ahoo.pigeon.core.bus.subscriber.*;
import me.ahoo.pigeon.core.bus.subscriber.impl.DefaultSubscriberGroupIdParser;
import me.ahoo.pigeon.core.bus.subscriber.impl.DefaultSubscriberRegistry;
import me.ahoo.pigeon.core.bus.subscriber.support.ImSubscriberAnnotationBeanPostProcessor;
import me.ahoo.pigeon.core.bus.subscriber.impl.DefaultSubscriberFactory;
import me.ahoo.pigeon.core.connector.ConnectorId;
import me.ahoo.pigeon.core.codec.DecoderRegistrar;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

/**
 * @author ahoo wang
 * Creation time: 2020/3/18 11:44
 */
@EnableConfigurationProperties(BusProperties.class)
@Configuration(proxyBeanMethods = false)
public class BusAutoConfiguration {

    private final BusProperties busProperties;

    public BusAutoConfiguration(BusProperties busProperties) {
        this.busProperties = busProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public TopicParser topicParser() {
        return new DefaultTopicParser(busProperties.getTopicPrefix());
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberGroupIdParser subscriberGroupIdParser() {
        return new DefaultSubscriberGroupIdParser(busProperties.getGroupPrefix());
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionHandler exceptionHandler() {
        return ExceptionHandler.LOGGER;
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberFactory subscriberFactory(@Nullable ConnectorId connectorId, SubscriberGroupIdParser subscriberGroupIdParser, SubscriberTopicParser subscriberTopicParser, ExceptionHandler exceptionHandler) {
        return new DefaultSubscriberFactory(connectorId, subscriberGroupIdParser, subscriberTopicParser, exceptionHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public ImSubscriberAnnotationBeanPostProcessor imSubscriberAnnotationBeanPostProcessor(SubscriberRegistry subscriberRegistry, SubscriberFactory subscriberFactory, DecoderRegistrar decoderRegistrar) {
        return new ImSubscriberAnnotationBeanPostProcessor(subscriberRegistry, subscriberFactory, decoderRegistrar);
    }

    @ConditionalOnMissingClass({
            "me.ahoo.pigeon.bus.rabbit.RabbitMessageBus",
            "me.ahoo.pigeon.bus.kafka.KafkaMessageBus"
    })
    public static class None {
        @Bean
        @ConditionalOnMissingBean
        public SubscriberRegistry subscriberRegistry() {
            return new DefaultSubscriberRegistry();
        }

        @Bean
        @ConditionalOnMissingBean
        public MessageBus messageBus(SubscriberRegistry subscriberRegistry, MessageTopicParser messageTopicParser) {
            return new MemoryMessageBus(Dispatcher.DEFAULT, messageTopicParser, subscriberRegistry);
        }
    }
}
