package me.ahoo.pigeon.starter.bus.kafka;

import me.ahoo.pigeon.starter.EnabledSuffix;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author ahoo wang
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@ConditionalOnProperty(value = BusKafkaProperties.PREFIX + EnabledSuffix.SUFFIX, havingValue = "true",matchIfMissing = true)
public @interface ConditionalOnKafkaEnabled {
}
