package me.ahoo.pigeon.starter.bus.rabbit;

import me.ahoo.pigeon.bus.rabbit.RabbitMessageBus;
import me.ahoo.pigeon.bus.rabbit.RabbitSubscriberRegistry;
import me.ahoo.pigeon.bus.rabbit.codec.RabbitMessageDecoder;
import me.ahoo.pigeon.bus.rabbit.codec.RabbitMessageEncoder;
import me.ahoo.pigeon.core.bus.MessageBus;
import me.ahoo.pigeon.core.bus.MessageTopicParser;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberRegistry;
import me.ahoo.pigeon.core.codec.CompositeStringToMessageDecoder;
import me.ahoo.pigeon.core.codec.MessageToStringEncoder;
import me.ahoo.pigeon.core.id.IdGenerator;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * @author ahoo wang
 * Creation time: 2020/3/19 14:22
 */
@EnableConfigurationProperties(BusRabbitProperties.class)
@AutoConfigureAfter(RabbitAutoConfiguration.class)
@ConditionalOnClass(RabbitMessageBus.class)
@ConditionalOnRabbitEnabled
public class BusRabbitAutoConfiguration {
    private final BusRabbitProperties busRabbitProperties;

    public BusRabbitAutoConfiguration(BusRabbitProperties busRabbitProperties) {

        this.busRabbitProperties = busRabbitProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitMessageEncoder rabbitMessageEncoder(MessageToStringEncoder messageToStringEncoder) {
        return new RabbitMessageEncoder(messageToStringEncoder);
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitMessageDecoder rabbitMessageDecoder(CompositeStringToMessageDecoder compositeStringToMessageDecoder) {
        return new RabbitMessageDecoder(compositeStringToMessageDecoder);
    }


    @Bean
    @ConditionalOnMissingBean
    public SubscriberRegistry subscriberRegistry(ConnectionFactory connectionFactory,
                                                 RabbitMessageDecoder rabbitMessageDecoder,
                                                 RabbitListenerEndpointRegistry rabbitListenerEndpointRegistry) {
        return new RabbitSubscriberRegistry(busRabbitProperties, connectionFactory,  rabbitMessageDecoder, rabbitListenerEndpointRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageBus messageBus(RabbitMessageEncoder rabbitMessageEncoder,
                                 SubscriberRegistry subscriberRegistry,
                                 MessageTopicParser messageTopicParser,
                                 ConnectionFactory connectionFactory,
                                 IdGenerator idGenerator) {
        return new RabbitMessageBus(busRabbitProperties, rabbitMessageEncoder, subscriberRegistry, messageTopicParser, connectionFactory, idGenerator);
    }
}
