package me.ahoo.pigeon.starter.codec;

import me.ahoo.pigeon.core.codec.CompositeStringToMessageDecoder;
import me.ahoo.pigeon.core.codec.DecoderRegistrar;
import me.ahoo.pigeon.core.codec.MessageToStringEncoder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * @author ahoo wang
 * Creation time: 2020/3/18 11:44
 */
@Configuration(proxyBeanMethods = false)
public class CodecAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public MessageToStringEncoder messageToStringEncoder() {
        return new MessageToStringEncoder();
    }

    @Bean
    @ConditionalOnMissingBean
    public DecoderRegistrar decoderRegistrar() {
        return new DecoderRegistrar();
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    public CompositeStringToMessageDecoder compositeStringToMessageDecoder(DecoderRegistrar decoderRegistrar) {
        return new CompositeStringToMessageDecoder(decoderRegistrar);
    }
}
