package me.ahoo.pigeon.starter.core;

import me.ahoo.pigeon.core.connector.ConnectorId;
import me.ahoo.pigeon.core.id.impl.*;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.annotation.Nullable;
import java.util.Objects;

/**
 * @author ahoo wang
 * Creation time: 2020/3/18 21:58
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(IdProperties.class)
public class CoreAutoConfiguration {

    @Primary
    @Bean
    @ConditionalOnMissingBean
    public MillisecondSnowflakeId idGenerator(@Nullable IdProperties idProperties, @Nullable ConnectorId connectorId) {
        Integer machineId = getMachineId(idProperties, connectorId);
        return new MillisecondSnowflakeId(machineId);
    }

    @Bean
    @ConditionalOnBean(MillisecondSnowflakeId.class)
    public MillisecondSnowflakeIdStateParser millisecondSnowflakeIdStateParser(MillisecondSnowflakeId millisecondSnowflakeId) {
        return MillisecondSnowflakeIdStateParser.of(millisecondSnowflakeId);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecondSnowflakeId safeJavaScriptSecondSnowflakeId(@Nullable IdProperties idProperties, @Nullable ConnectorId connectorId) {
        Integer machineId = getMachineId(idProperties, connectorId);
        return SafeJavaScriptSnowflakeId.ofSecond(machineId);
    }

    @Bean
    @ConditionalOnBean(SecondSnowflakeId.class)
    public SecondSnowflakeIdStateParser secondSnowflakeIdStateParser(SecondSnowflakeId millisecondSnowflakeId) {
        return SecondSnowflakeIdStateParser.of(millisecondSnowflakeId);
    }

    private Integer getMachineId(@Nullable IdProperties idProperties, @Nullable ConnectorId connectorId) {
        Integer machineId = 1;
        if (Objects.nonNull(idProperties) && Objects.nonNull(idProperties.getSnowflake())) {
            machineId = idProperties.getSnowflake().getMachineId();
        } else if (Objects.nonNull(connectorId)) {
            machineId = connectorId.getId();
        }
        return machineId;
    }
}
