package me.ahoo.pigeon.starter.relation;

import me.ahoo.pigeon.core.relation.*;
import me.ahoo.pigeon.core.relation.none.*;
import me.ahoo.pigeon.relation.redis.*;
import me.ahoo.pigeon.relation.redis.*;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.*;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

/**
 * @author ahoo wang
 * Creation time: 2020/3/18 11:04
 */
@Configuration(proxyBeanMethods = false)
public class RelationAutoConfiguration {

    @ConditionalOnMissingClass("me.ahoo.pigeon.relation.redis.RedisConnectorUserRelationService")
    public static class None {
        @Bean
        @ConditionalOnMissingBean
        public ConnectorUserRelationService connectorUserRelationService() {
            return new NoneConnectorUserRelationService();
        }

        @Bean
        @ConditionalOnMissingBean
        public DeviceConnectorRelationService deviceConnectorRelationService() {
            return new NoneDeviceConnectorRelationService();
        }

        @Bean
        @ConditionalOnMissingBean
        public GroupUserRelationService groupUserRelationService() {
            return new NoneGroupUserRelationService();
        }

        @Bean
        @ConditionalOnMissingBean
        public RoomConnectorRelationService roomConnectorRelationService() {
            return new NoneRoomConnectorRelationService();
        }

        @Bean
        @ConditionalOnMissingBean
        public UserConnectorRelationService userConnectorRelationService() {
            return new NoneUserConnectorRelationService();
        }
    }

    @AutoConfigureAfter(RedisAutoConfiguration.class)
    @ConditionalOnClass(RedisConnectorUserRelationService.class)
    public static class Redis {

        @Bean
        @ConditionalOnMissingBean
        public StringIntegerRedisTemplate stringIntegerRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
            StringIntegerRedisTemplate template = new StringIntegerRedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }

        @Bean
        @ConditionalOnMissingBean
        public StringLongRedisTemplate stringLongRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
            StringLongRedisTemplate template = new StringLongRedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }

        @Bean
        @ConditionalOnMissingBean
        public ConnectorUserRelationService connectorUserRelationService(StringLongRedisTemplate redisTemplate) {
            return new RedisConnectorUserRelationService(redisTemplate);
        }

        @Bean
        @ConditionalOnMissingBean
        public DeviceConnectorRelationService deviceConnectorRelationService(StringIntegerRedisTemplate redisTemplate) {
            return new RedisDeviceConnectorRelationService(redisTemplate);
        }

        @Bean
        @ConditionalOnMissingBean
        public GroupUserRelationService groupUserRelationService(StringLongRedisTemplate redisTemplate) {
            return new RedisGroupUserRelationService(redisTemplate);
        }

        @Bean
        @ConditionalOnMissingBean
        public RoomConnectorRelationService roomConnectorRelationService(StringIntegerRedisTemplate redisTemplate) {
            return new RedisRoomConnectorRelationService(redisTemplate);
        }

        @Bean
        @ConditionalOnMissingBean
        public UserConnectorRelationService userConnectorRelationService(StringIntegerRedisTemplate redisTemplate) {
            return new RedisUserConnectorRelationService(redisTemplate);
        }
    }
}
