package me.ahoo.pigeon.starter.security;

import me.ahoo.pigeon.core.security.authorization.jwt.config.DeviceConfig;
import me.ahoo.pigeon.core.security.authorization.jwt.config.RoomConfig;
import me.ahoo.pigeon.core.security.authorization.jwt.config.UserConfig;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * @author ahoo wang
 * Creation time: 2020/3/18 11:51
 */
public class AuthProperties {

    @NestedConfigurationProperty
    private Jwt jwt;

    public Jwt getJwt() {
        return jwt;
    }

    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

    public static class Jwt {
        @NestedConfigurationProperty
        private UserConfig user;
        @NestedConfigurationProperty
        private DeviceConfig device;
        @NestedConfigurationProperty
        private RoomConfig room;

        public UserConfig getUser() {
            return user;
        }

        public void setUser(UserConfig user) {
            this.user = user;
        }

        public DeviceConfig getDevice() {
            return device;
        }

        public void setDevice(DeviceConfig device) {
            this.device = device;
        }

        public RoomConfig getRoom() {
            return room;
        }

        public void setRoom(RoomConfig room) {
            this.room = room;
        }
    }
}
