/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.starter.bus.kafka;

import me.ahoo.pigeon.bus.kafka.KafkaMessageBus;
import me.ahoo.pigeon.bus.kafka.KafkaSubscriberRegistry;
import me.ahoo.pigeon.bus.kafka.codec.KafkaMessageDecoder;
import me.ahoo.pigeon.bus.kafka.codec.KafkaMessageEncoder;
import me.ahoo.pigeon.core.bus.MessageBus;
import me.ahoo.pigeon.core.bus.MessageTopicParser;
import me.ahoo.pigeon.core.bus.subscriber.SubscriberRegistry;
import me.ahoo.pigeon.core.codec.CompositeStringToMessageDecoder;
import me.ahoo.pigeon.core.codec.MessageToStringEncoder;
import me.ahoo.pigeon.core.id.IdGenerator;
import me.ahoo.pigeon.starter.bus.kafka.BusKafkaProperties;
import me.ahoo.pigeon.starter.bus.kafka.ConditionalOnKafkaEnabled;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.core.KafkaTemplate;

@EnableConfigurationProperties(value={BusKafkaProperties.class})
@AutoConfigureAfter(value={KafkaAutoConfiguration.class})
@ConditionalOnClass(value={KafkaMessageBus.class})
@ConditionalOnKafkaEnabled
public class BusKafkaAutoConfiguration {
    private final BusKafkaProperties busKafkaProperties;
    private final KafkaProperties kafkaProperties;

    public BusKafkaAutoConfiguration(BusKafkaProperties busKafkaProperties, KafkaProperties kafkaProperties) {
        this.busKafkaProperties = busKafkaProperties;
        this.kafkaProperties = kafkaProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaMessageEncoder kafkaMessageEncoder(MessageTopicParser messageTopicParser, MessageToStringEncoder messageToStringEncoder) {
        return new KafkaMessageEncoder(messageTopicParser, messageToStringEncoder);
    }

    @Bean
    @ConditionalOnMissingBean
    public KafkaMessageDecoder kafkaMessageDecoder(CompositeStringToMessageDecoder compositeStringToMessageDecoder) {
        return new KafkaMessageDecoder(compositeStringToMessageDecoder);
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberRegistry subscriberRegistry(KafkaMessageDecoder kafkaMessageDecoder, KafkaListenerEndpointRegistry listenerEndpointRegistry, ConcurrentKafkaListenerContainerFactory concurrentKafkaListenerContainerFactory) {
        return new KafkaSubscriberRegistry(kafkaMessageDecoder, listenerEndpointRegistry, concurrentKafkaListenerContainerFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageBus messageBus(KafkaMessageEncoder kafkaMessageEncoder, IdGenerator idGenerator, KafkaTemplate kafkaTemplate, KafkaSubscriberRegistry kafkaSubscriberRegistry) {
        return new KafkaMessageBus(kafkaMessageEncoder, idGenerator, kafkaTemplate, kafkaSubscriberRegistry);
    }
}

