/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.pigeon.starter.connector;

import me.ahoo.cosky.discovery.ServiceDiscovery;
import me.ahoo.cosky.discovery.loadbalancer.LoadBalancer;
import me.ahoo.pigeon.connector.discovery.ConnectorDiscovery;
import me.ahoo.pigeon.connector.discovery.ConnectorLoadBalancer;
import me.ahoo.pigeon.connector.discovery.cosky.CoskyConnectorDiscovery;
import me.ahoo.pigeon.connector.discovery.cosky.CoskyConnectorLoadBalancer;
import me.ahoo.pigeon.starter.connector.ConnectorDiscoveryProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ConnectorDiscoveryProperties.class})
@ConditionalOnProperty(prefix="pigeon.connector-discovery", name={"service-id"})
@ConditionalOnBean(value={ServiceDiscovery.class})
public class ConnectorDiscoveryAutoConfiguration {
    private final ConnectorDiscoveryProperties connectorDiscoveryProperties;

    public ConnectorDiscoveryAutoConfiguration(ConnectorDiscoveryProperties connectorDiscoveryProperties) {
        this.connectorDiscoveryProperties = connectorDiscoveryProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectorDiscovery connectorDiscovery(ServiceDiscovery serviceDiscovery) {
        return new CoskyConnectorDiscovery(serviceDiscovery, this.connectorDiscoveryProperties.getServiceId());
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectorLoadBalancer connectorLoadBalancer(LoadBalancer loadBalancer) {
        return new CoskyConnectorLoadBalancer(loadBalancer, this.connectorDiscoveryProperties.getServiceId());
    }
}

